% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcm.R
\name{gcm.test}
\alias{gcm.test}
\title{Test for Conditional Independence Based on the Generalized Covariance Measure (GCM)}
\usage{
gcm.test(X, Y, Z = NULL, alpha = 0.05, regr.method = "xgboost",
  regr.pars = list(), plot.residuals = FALSE, nsim = 499L,
  resid.XonZ = NULL, resid.YonZ = NULL)
}
\arguments{
\item{X}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{Y}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{Z}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{alpha}{Significance level of the test.}

\item{regr.method}{A string indicating the regression method that is used. Currently implemented are 
"gam", "xgboost", "kernel.ridge". The regression is performed only if 
not both resid.XonZ and resid.YonZ are set to NULL.}

\item{regr.pars}{Some regression methods require a list of additional options.}

\item{plot.residuals}{A Boolean indicating whether some plots should be shown.}

\item{nsim}{An integer indicating the number of bootstrap samples used to approximate the null distribution of the
test statistic.}

\item{resid.XonZ}{It is possible to directly provide the residuals instead of performing a regression. 
If set to NULL, the regression method specified in regr.method is used.}

\item{resid.YonZ}{It is possible to directly provide the residuals instead of performing a regression. 
If set to NULL, the regression method specified in regr.method is used.}
}
\value{
The function tests whether X is conditionally independent of Y given Z. The output is a list containing
\itemize{
\item \code{p.value}: P-value of the test. 
\item \code{test.statistic}: Test statistic of the test.
\item \code{reject}: Boolean that is true iff p.value < alpha.
}
}
\description{
Test for Conditional Independence Based on the Generalized Covariance Measure (GCM)
}
\examples{
set.seed(1)
n <- 250 
Z <- 4*rnorm(n) 
X <- 2*sin(Z) + rnorm(n)
Y <- 2*sin(Z) + rnorm(n)
Y2 <- 2*sin(Z) + X + rnorm(n)
gcm.test(X, Y, Z, regr.method = "gam")
gcm.test(X, Y2, Z, regr.method = "gam")

}
\references{
Please cite the following paper.
Rajen D. Shah, Jonas Peters: 
"The Hardness of Conditional Independence Testing and the Generalised Covariance Measure"
\url{https://arxiv.org/abs/1804.07203}
}
