% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoRange_MultiTaxa.R
\name{GeoRange_MultiTaxa}
\alias{GeoRange_MultiTaxa}
\title{Function to tabulate number of occurrences/locations, six geographic range measures, minimum and maximum latitude and longitude for each taxon in a dataset}
\usage{
GeoRange_MultiTaxa(OccMatrix, TaxaStart, LongPos = 1, LatPos = 2,
  CellSize = 5, longBounds = c(-180, 180), latBounds = c(-90, 90))
}
\arguments{
\item{OccMatrix}{- A matrix where columns are taxon occurrences and also having at least longitude and latitude values}

\item{TaxaStart}{- The column index value where taxon records start}

\item{LongPos}{- The column index value of longitudinal coordinates in the OccMatrix}

\item{LatPos}{- The column index value of latitudinal coordinates in the OccMatrix}

\item{CellSize}{- The size of each cell in degree X degree}

\item{longBounds}{- Array of longitudinal boundaries in decimal degrees}

\item{latBounds}{- Array of latitudinal boundaries in decimal degrees}
}
\value{
Returns a matrix of taxa by geographic range measures, including number of observations, number of unique locations observed at, minimum spanning tree distance, minimum convex hull area, maximum pairwise great circle distance, latitudinal range, longitudinal range, and number of degree X degree cells occupied
}
\description{
Function to tabulate number of occurrences/locations, six geographic range measures, minimum and maximum latitude and longitude for each taxon in a dataset
}
\note{
Calculates the number of observations, localities, minimum spanning tree distance, convex hull area, longitudinal range, latitudinal range, and cell count
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
GeoRange_MultiTaxa(OccMatrix=BivalveMatrix,TaxaStart=3)
}
}
\seealso{
See the velociraptr package for details of the downloadPBDB() function
}
