% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sensitivity.R
\name{plot_sensitivity}
\alias{plot_sensitivity}
\title{Plot results of sensitivity analysis.}
\usage{
plot_sensitivity(
  x,
  metric = "GCA.Eff",
  assay = NULL,
  y = "",
  xlab = metric,
  ylab = ""
)
}
\arguments{
\item{x}{GeoTox object.}

\item{metric}{metric to plot. Valid choices are "GCA.Eff", "IA.Eff",
"GCA.HQ.10", and "IA.HQ.10".}

\item{assay}{which assay to plot, if multiple exist.}

\item{y}{y value or text for bottom of ridge plot.}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}
}
\value{
ggplot2 object.
}
\description{
Plot results of sensitivity analysis.
}
\examples{
# Required GeoTox fields are generated by first running [calculate_response]
# and [sensitivity_analysis] on a GeoTox object. This will create the fields
# `resp` and `sensitivity`. For this example, dummy data will be used.
make_data <- function(n = 5, metric = "GCA.Eff") {
  list(stats::setNames(data.frame(1:n, runif(n)),
                       c("sample", metric)))
}

geoTox <- GeoTox()
geoTox$resp <- make_data()
geoTox$sensitivity <- list(age = make_data(),
                           obesity = make_data(),
                           css_params = make_data(),
                           fit_params = make_data(),
                           C_ext = make_data())

plot_sensitivity(geoTox)
}
