% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregory.R
\name{Gregory_weights}
\alias{Gregory_weights}
\title{Calculate the Gregory quadrature weights for equispaced integration. If f is
a row vector containing the function values, the integral is approximated by
the statement \code{f \%*\% t(w)} where w are the returned weights. Translated
from https://www.colorado.edu/amath/sites/default/files/attached-files/gregory.pdf.}
\usage{
Gregory_weights(n_nodes, h, order)
}
\arguments{
\item{n_nodes}{Total number of nodes}

\item{h}{Step size}

\item{order}{Order of accuracy desired. 2, 3, 4, ... (with 2 giving the trapezoidal rule). The value must satisfy 2 <= order <= n_nodes}
}
\value{
The weights to be used for the successive function values
}
\description{
Calculate the Gregory quadrature weights for equispaced integration. If f is
a row vector containing the function values, the integral is approximated by
the statement \code{f \%*\% t(w)} where w are the returned weights. Translated
from https://www.colorado.edu/amath/sites/default/files/attached-files/gregory.pdf.
}
\examples{
n_nodes = 11
order = 8
h = 2/(n_nodes-1)
x = pracma::linspace(-1, 1, n_nodes)
f = exp(x)

w = GregoryQuadrature::Gregory_weights(n_nodes, h, order)
int = f \%*\% w
# Exact value for integral
exact = exp(1) - exp(-1)

error = int - exact
}
