% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca.R
\name{sca}
\alias{sca}
\title{Simultaneous Component Analysis}
\usage{
sca(object)
}
\arguments{
\item{object}{A \code{hdanova} object.}
}
\value{
An updated \code{hdanova} object with SCA results.
}
\description{
This function performs Simultaneous Component Analysis (SCA) on a \code{hdanova} object.
}
\examples{
# Load candies data
data(candies)

# Basic HDANOVA model with two factors
mod <- hdanova(assessment ~ candy + assessor, data=candies)
mod <- sca(mod)
scoreplot(mod)

}
