% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDJM_wrapper.R
\name{HDJM_fit}
\alias{HDJM_fit}
\title{The function to fit penalized HDJM.}
\usage{
HDJM_fit(
  LongData = NULL,
  SurvData = NULL,
  marker.name = NULL,
  control_list = NULL,
  nlam = 50,
  ridge = 0,
  pmax = 10,
  min_ratio = 0.01,
  maxiter = 100,
  eps = 1e-04,
  UseSurvN = FALSE
)
}
\arguments{
\item{LongData}{a data frame containing the longitudinal data
(see \code{\link{LongData}}).}

\item{SurvData}{a data frame containing the survival data
(see \code{\link{SurvData}}).}

\item{marker.name}{a vector indicating which set of longitudinal biomarkers
to be analyzed. If NULL, all biomarkers in LongData will be used.}

\item{control_list}{a list of parameters specifying the joint model
(see \code{\link{control_list}}).}

\item{nlam}{number of tuning parameters.}

\item{ridge}{ridge penalty.}

\item{pmax}{the maximum of biomarkers being selected.
The algorithm will stop early if the maximum has been reached.}

\item{min_ratio}{the ratio between the largest possible penalty
and the smallest penalty to tune.}

\item{maxiter}{the maximum number of iterations.}

\item{eps}{threshold for convergence.}

\item{UseSurvN}{a logical variable indicating whether the
effective sample size (i.e., the number of events) should be
used in calculating BIC.}
}
\value{
return a list with the following objects.
\item{marker.name}{the names for biomarkers being analyzed.}
\item{alpha}{the estimates for the effects of biomarkers
in the survival submodel.}
\item{weib}{the estimates for the Weibull baseline hazard
in the survival submodel.}
\item{gamma}{the estimates for the effects of baseline covariates
in the survival submodel.}
\item{beta}{the estimates for the fixed-effects
in the longitudinal submodel.}
\item{sig2}{the estimates for the noise variances
in the longitudinal submodel.}
\item{Sigma}{the estimates for the covariance matrices of the
random effects in the longitudinal submodel.}
}
\description{
The function is used to fit the penalized HDJM with adpative lasso penalty.
}
\examples{
data(HDJMdata)
flex_time_fun <- function(x=NULL){
    xx = matrix(x, ncol = 1)
    colnames(xx) = c("year_l")
    xx
}
ran_time_ind = 1 ## random time-trend effects
control_list = list(
  ID_name = "ID", item_name = "item",
  value_name = "value",  time_name = "years",
  fix_cov = NULL, random_cov = NULL,
  FUN = flex_time_fun, ran_time_ind=ran_time_ind,
  surv_time_name = "ftime",  surv_status_name = "fstat",
  surv_cov = "x", n_points = 5
)
\donttest{
## takes about one minute.
res = HDJM_fit(LongData=LongData, SurvData=SurvData,
               control_list=control_list)
}

}
\references{
Jiehuan Sun and Sanjib Basu. "Penalized Joint Models of
High-Dimensional Longitudinal Biomarkers and A Survival Outcome".
}
