% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmstat.baraxis.R
\name{mmstat.baraxis}
\alias{mmstat.baraxis}
\title{mmstat.baraxis}
\usage{
mmstat.baraxis(side, range, at, labels, ...)
}
\arguments{
\item{side}{an integer specifying which side of the plot the axis is
    to be drawn on.  The axis is placed as follows: 1=below,
    2=left, 3=above and 4=right.}

\item{range}{range: a data range}

\item{at}{the points at which tick-marks are to be drawn.  Non-finite
    (infinite, \code{NaN} or \code{NA}) values are omitted.  By default
    (when \code{NULL}) tickmark locations are computed, see
    \sQuote{Details} below.}

\item{labels}{this can either be a logical value specifying whether
    (numerical) annotations are to be made at the tickmarks, or a
    character or expression vector of labels to be placed at the
    tickpoints.  (Other objects are coerced by \code{\link{as.graphicsAnnot}}.)
    If this is not logical, \code{at} should also be supplied and of the
    same length.  If \code{labels} is of length zero after coercion,
    it has the same effect as supplying \code{TRUE}.}

\item{...}{further parameters to \link[graphics:axis]{graphics::axis}}
}
\value{
adds a axis to a plot
}
\description{
Based on \code{range} the position of the labels are determined and the axis is plotted.
}
\examples{
oldpar <- par(mfrow=c(1,2))
x <- 0:15
px <- dbinom(x, 10, 0.5)
plot(x, px, type="h")
plot(x, px, type="h", axes=FALSE)
mmstat.baraxis(1, range(x), at=x, labels=as.character(x))
par(oldpar)
}
