% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2SPOR_DynProg.R
\name{H2SPOR_DynProg}
\alias{H2SPOR_DynProg}
\title{Inference method that does not require a priori knowledge of the number of regimes and uses
dynamic programming}
\usage{
H2SPOR_DynProg(X, Y, deg, constraint = 1, EM = TRUE, plotG = TRUE)
}
\arguments{
\item{X}{A numerical vector corresponding to the explanatory variable. X must be sorted in ascending order
if this is not the case, X will be sorted in the function and the corresponding permutation will be applied to Y. The
user will be notified by a warning message. In addition, if X contains NAs, they will be deleted from the data and the user will be notified by a warning message.
Finally, if X contains duplicate data, the excess data will be deleted and the user will be notified by a warning message.}

\item{Y}{A numerical vector corresponding to the variable to be explain. It should contain at least two regimes that
could be modelled by polynomials. In addition, if Y contains NAs they will be deleted from the data and the
user will be notified by a warning message. Finally, if X contains dupplicate data, the excess data will be deleted and
the value of the remaining Y will become the average of the Ys, calculated for this value of X.}

\item{deg}{Degree of the polynomials. The size of X and Y must be greater than  2(deg+2) + 1.}

\item{constraint}{Number that determines the regularity assumption that is applied for the parameters estimation.
By default, the variable is set to 1, i. e. the parameters estimation is done under continuity constraint.
If the variable is 0 or 2, the estimation of the parameters will be done without assumption of regularity
(constraint = 0) or under assumption of differentiability (constraint = 2). Warning, if the differentiability
assumption is not verified by the model, it is preferable not to use it to estimate the model parameters.
In addition, if the degree of the polynomials is equal to 1, you cannot use the differentiability assumption.}

\item{EM}{A Boolean. If EM is TRUE (default), then the function will estimate the parameters
of a latent variable polynomial regression model using an EM algorithm. If EM is FALSE then
the function will estimate the parameters of the initial polynomial regression model by a fixed point algorithm.}

\item{plotG}{A Boolean. If TRUE (default) the estimation results obtained by the H2SPOR_DynProg function are plotted.}
}
\value{
A dataframe which contains the estimated parameters of the polynomial regression model at
an estimated number of regimes: the times of jump, the polynomials coefficients and the variances
of an estimated number of regimes.
If plotG = TRUE, the data(X,Y) and the estimated model will be plotted.
}
\description{
H2SPOR_DynProg is an inference method implemented as a binary segmentation algorithm.
This method makes it possible to estimate, using dynamic programming and under regularity assumption,
the parameters of a piecewise polynomial regression model when we have no a priori knowledge of the number
 of regimes.
}
\examples{
set.seed(1)
#generated data with two regimes
xgrid1 = seq(0,10,length.out = 6)
xgrid2 = seq(10.2,20,length.out=6)
ygrid1 = xgrid1^2-xgrid1+1+ rnorm(length(xgrid1),0,3)
ygrid2 = rep(91,length(xgrid2))+ rnorm(length(xgrid2),0,3)
xgrid = c(xgrid1,xgrid2)
ygrid = c(ygrid1,ygrid2)
# Inference of a piecewise polynomial regression model on these data.
#The degree of the polynomials is fixed to 2 and the parameters are estimated
#under continuity constraint.
H2SPOR_DynProg(xgrid,ygrid,2,1,EM=FALSE)

\donttest{
set.seed(1)
xgrid1 = seq(0,10,by=0.2)
xgrid2 = seq(10.2,20,by=0.2)
xgrid3 = seq(20.2,30,by=0.2)
ygrid1 = xgrid1^2-xgrid1+1+ rnorm(length(xgrid1),0,3)
ygrid2 = rep(91,length(xgrid2))+ rnorm(length(xgrid2),0,3)
ygrid3 = -10*xgrid3+300+rnorm(length(xgrid3),0,3)
datX = c(xgrid1,xgrid2,xgrid3)
datY = c(ygrid1,ygrid2,ygrid3)
#Inference of a piecewise polynomial regression model on these data.
#The degree of the polynomials is fixed to 2 and the parameters are estimated
#under continuity constraint.
H2SPOR_DynProg(datX,datY,2,1)
#Executed time : 2.349685 mins (intel core i7 processor)
}
}
