% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themodel.R
\name{themodel}
\alias{themodel}
\title{Model fitting}
\usage{
themodel(formula, data, usebinary = 1, clean = TRUE)
}
\arguments{
\item{formula}{a formula for model-fitting, starting with outcome~.}

\item{data}{a data frame contains all the variables included in the formula.
The outcome must be the first column with colnames(data)[1]="outcome".}

\item{usebinary}{a non-negative number representing different models.
Use linear model if \code{usebinary=0},
use logistic regression model via \code{fastglm} if \code{usebinary=1} (by default),
and use logistic regression model via \code{glm} if \code{usebinary>1}.}

\item{clean}{logical. If \code{clean=TRUE} (by default), remove additional storages that
the \code{predict} function, \code{"AIC"} and \code{"BIC"} criteria do not need.}
}
\value{
a fitted model.
}
\description{
Model-agnostic functions for model fitting (both linear and generalized linear models).
}
\details{
This function returns a fitted model (either linear model or logistic regression model).
For logistic regression, we use function \code{fastglm} from \code{fastglm} package, which is much faster than \code{glm}.
}
\examples{
## create the dataset for variables and outcome
x=matrix(runif(100,-2,2),ncol=5)
outcome=0.5*x[,2] - 0.8*x[,4] + 0.3*x[,5]
data1=data.frame(outcome,x)

## fit a linear model
themodel(outcome~.,data1,usebinary=0)

## create binary outcome
outcome=outcome>runif(100,-2,2)
outcome[outcome]=1
data2=data.frame(outcome,x)

## fit a logistic regression model
themodel(outcome~.,data2,usebinary=1)
}
