% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_goethals_base.R
\name{cdn_goethals_base}
\alias{cdn_goethals_base}
\title{cdn_goethals_base}
\source{
The Base sequences were obtained from \href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos}
}
\usage{
cdn_goethals_base(order)
}
\arguments{
\item{order}{integer}
}
\value{
7 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using available base sequences.
}
\details{
This function checks whether the Hadamard matrix of given order can be constructed using base sequences.
If base sequences of length n+1,n+1,n,n are available, T-sequences of length 2n+1,2n+1,2n+1,2n+1 can be constructed.
From T-sequence of length 2n+1, Hadamard matrix of order 4(2n+1) can be constructed.
Returns the value 7, if it is possible otherwise NULL is returned.

Base sequences are available in the internal dataset is  1:35
}
\examples{
cdn_goethals_base(20)
#7
cdn_goethals_base(24)
#NULL

}
\references{
Goethals, J. M. and Seidel, J. J. (1967). Orthogonal matrices with zero diagnol. Canad. J. Math., 19, 259-264.
}
\seealso{
\code{\link{had_goethals_base}} for Goethals-Seidel construction method.

\code{\link{baseseq}}
}
