% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_hadamard.R
\name{check_hadamard}
\alias{check_hadamard}
\title{check_hadamard}
\usage{
check_hadamard(x)
}
\arguments{
\item{x}{matrix}
}
\value{
returns a text message
}
\description{
check_hadamard tests whether the input matrix  is an Hadamard matrix or not.
}
\details{
This function can be used to check whether a given matrix is an Hadamard Matrix or not.
To ensure that generated matrix is indeed an Hadamard matrix, this function can be used. In case,
if the given matrix is an Hadamard matrix, a text message, Given matrix is an Hadamard Matrix of order is printed on the console.

This function checks (i)Input is a matrix; (ii)a square matrix; (iii)Order of the matrix is an Hadamard number;
(iv) All elements are either +1 or -1; (v) HH'=nI, where n is the order of the input matrix H and H' is transpose of H.
}
\examples{
#Example 1:
h<-matrix(c(1,1,1,-1),nrow=2,ncol=2)
check_hadamard(h)
# Given matrix is an Hadamard Matrix of order 2
#Example 2:
h<-matrix(c(1,-1,1,-1),nrow=2,ncol=2)
check_hadamard(h)
#Not an Hadamard matrix
#Example 3:
h<-Hadamard_Matrix(36)
check_hadamard(h)
#"Given matrix is an Hadamard Matrix of order 36"
}
\references{
Hedayat, A. and Wallis, W.D. (1978). Hadamard Matrices and Their Application.Ann. Stat., 6, 1184-1238.
}
