% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coralPlotBeta.R
\name{coralPlotBeta}
\alias{coralPlotBeta}
\title{coralPlotBeta}
\usage{
coralPlotBeta(
  mu,
  V,
  phyloTree,
  spNames.common,
  plotColumns = c(1:ncol(mu)),
  quantile.support = c(0.05, 0.95),
  plotTree = 0.3,
  seed = NULL,
  col.common = c("blue", "red"),
  alpha.common = 0.5,
  jitter.common = 0.45,
  cex.common = 0.5,
  pch.common = 16,
  col.rare = c("cyan", "pink"),
  alpha.rare = 0.5,
  jitter.rare = 0.2,
  cex.rare = 0.2,
  pch.rare = 16,
  showCovNames = TRUE
)
}
\arguments{
\item{mu}{CORAL-like matrix of means}

\item{V}{CORAL-like matrix of flattened variances}

\item{phyloTree}{phylogenetic tree covering all species}

\item{spNames.common}{species names designated as common in CORAL analysis}

\item{plotColumns}{vector of covariates' indices to be included to the plot}

\item{quantile.support}{what lower and upper tails of species coefficients to visualize}

\item{plotTree}{proportion of the plot canvas to use for the phylogenetic tree, 0 for no tree}

\item{seed}{random seed used for jittering}

\item{col.common}{a vector of two color strings indicating lower and upper tails among common species}

\item{alpha.common}{transparency for common species}

\item{jitter.common}{jitter amount for common species}

\item{cex.common}{size of points for common species}

\item{pch.common}{symbol type for common species}

\item{col.rare}{a vector of two color strings indicating lower and upper tails among rare species}

\item{alpha.rare}{transparency for rare species}

\item{jitter.rare}{jitter amount for rare species}

\item{cex.rare}{size of points for rare species}

\item{pch.rare}{symbol type for rare species}

\item{showCovNames}{whether to display covariate names in the plot}
}
\description{
Plots summary of Beta coefficients fitted with CORAL approach
}
