% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_context_functions.R
\name{HaplotypePlot}
\alias{HaplotypePlot}
\title{Generate Haplotype plot from a given list of sequences}
\usage{
HaplotypePlot(
  sequences,
  indel.class,
  flank.length = 5,
  title = "Haplotype Plot"
)
}
\arguments{
\item{sequences}{A list of strings returned from
\code{\link{SymmetricalContextsFor1BPIndel}}.}

\item{indel.class}{A single character string that denotes a 1 base pair
insertion or deletion, as taken from \code{ICAMS::catalog.row.order$ID}.
Insertions or deletions into or from 5+ base-pair homopolymers are not
supported.}

\item{flank.length}{The length of flanking bases around the position or
homopolymer targeted by the indel.}

\item{title}{The title of the haplotype plot}
}
\value{
A ggplot2 object
}
\description{
Generate Haplotype plot from a given list of sequences
}
\keyword{internal}
