% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromosome_name_functions.R
\name{SelectVariantsByChromName}
\alias{SelectVariantsByChromName}
\title{Select variants according to chromosome names specified by user}
\usage{
SelectVariantsByChromName(df, chr.names.to.process, name.of.VCF = NULL)
}
\arguments{
\item{df}{An in-memory data.frame representing a VCF.}

\item{chr.names.to.process}{A character vector specifying the chromosome
names in \code{df} whose variants will be kept.}

\item{name.of.VCF}{Name of the VCF file.}
}
\value{
A \strong{list} with the elements
\itemize{
\item \code{df}: A data frame with variants only from chromosomes specified by
\code{chr.names.to.process}.
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that are from chromosomes not specified by \code{chr.names.to.process}.
}
}
\description{
Select variants according to chromosome names specified by user
}
\keyword{internal}
