% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertDStoHS.R
\name{convertDStoHS}
\alias{convertDStoHS}
\title{Convert DS to HS}
\usage{
convertDStoHS(nindivs, nobs, DS, se = FALSE)
}
\arguments{
\item{nindivs}{Number of individuals. Must be within 5-40 individuals.}

\item{nobs}{Number of observations per individual. Must be within 5-20 observations.}

\item{DS}{DS value to be converted into HS. Must be within 0-1.}

\item{se}{should standard errors be computed (takes more time)?}
}
\value{
If \code{se = FALSE}, Numeric value. DS for a specified number of
  individuals and number of observations per individual. \cr If \code{se = TRUE},
  a list containing components fit, se, residual.scale, df. See
  \code{predict.loess} for more details.
}
\description{
This function converts DS to HS. Because the model used to convert values is
derived from \code{stats::loess model}, it cannot make predictions outside
the range of the values used to construct the model. The model was tailored
to the sampling frequently used by studies on individuality: \cr - number of
individuals should be between 5 and 40 individuals \cr - number of
observations per individual should be between 5 - 20 \cr - DS value should be
between 0 - 1 \cr\cr Consider increasing your sampling if number of
individuals and/or number of observations are lower than 5. If number of
individuals and observations exceeds the function limits, it might be
acceptable to use the largest possible values allowed by the model to get the
estimate - biases get smaller with larger sampling, so, if your sampling
exceeds function limits a little bit, the estimate should be still quite
precise.
}
\examples{
convertDStoHS(nindivs=10, nobs=10, DS=0.7)

}
\seealso{
Other metric conversion: \code{\link{convertHStoDS}}
}
\concept{metric conversion}
