% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot.IMEC}
\alias{plot.IMEC}
\title{Plots the explanatory relations}
\usage{
\method{plot}{IMEC}(x, nodesize = 10, ...)
}
\arguments{
\item{x}{Object of the class IMEC as returned by computeIMEC}

\item{nodesize}{size of vertices in the plotted network}

\item{...}{other parameters passed on to S3 method.}
}
\description{
Plot the explanatory relations between data and phenomena. A window will open where you
can drag the nodes in the intended position. Then press enter to plot the network.
}
\examples{
# simple example comparing two hypotheses one of them with more explanatory breadth##
T1 <- c("H1", "H2")
Phenomena <- c("E1", "E2")
Thresholds <- c(2,2)
explanations <- initializeNetwork(Phenomena, T1)
explanations <- explain("H1", "E1", explanations)
explanations <- explain("H1", "E2", explanations)
explanations <- explain("H2", "E2", explanations)
explanations <- contradict("H1", "H2", explanations)
coherence <- computeIMEC(explanations, Thresholds, Phenomena, T1)
summary(coherence)
plot(coherence)
}
