% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suspectacumprec.R
\name{suspectacumprec}
\alias{suspectacumprec}
\title{Detects precipitation values above limit}
\usage{
suspectacumprec(datos, limit = 2000, tolerance = 10)
}
\arguments{
\item{datos}{two columns vector, date and data, in the ECA&D format}

\item{limit}{threshold/limit value for atmospheric precipitation}

\item{tolerance}{how many consecutive days with 0 or NA you need to jump}
}
\value{
list of positions which do not pass this QC test
}
\description{
This function detects values above limit preceded by a number of "non precipitation days", given by tolerance
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "RR_SOUID132730.txt", package = "INQC")
#Read the data file
datos<-readecad(input=path2inptfl,missing= -9999)[,3:4]
#Find all suspicious positions in the precipitation time series
suspectacumprec(datos,limit=2000,tolerance=10)
}
