% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_IVDML.R
\name{standard_confint}
\alias{standard_confint}
\title{Compute Standard Confidence Interval for the Treatment Effect Estimate in an IVDML Object}
\usage{
standard_confint(
  object,
  iv_method,
  a = NULL,
  A = NULL,
  kernel_name = NULL,
  bandwidth = NULL,
  level = 0.95
)
}
\arguments{
\item{object}{An object of class \code{IVDML}, produced by the \code{\link[=fit_IVDML]{fit_IVDML()}} function.}

\item{iv_method}{Character. The instrumental variable estimation method to use. Must be one of the methods specified in the fitted object.}

\item{a}{Numeric (optional). A specific value of \code{A} at which to compute the confidence interval for the heterogeneous treatment effect. If \code{NULL}, the function returns the confidence interval for the homogeneous treatment effect.}

\item{A}{Numeric vector (optional). The variable with respect to which treatment effect heterogeneity is considered. If \code{NULL}, the function assumes the \code{A} used in object fitting.}

\item{kernel_name}{Character (optional). The name of the kernel function to use for smoothing (if a heterogeneous treatment effect is estimated). Must be one of "boxcar", "gaussian", "epanechnikov", or "tricube".}

\item{bandwidth}{Numeric (optional). The bandwidth for the kernel smoothing (if a heterogeneous treatment effect is estimated).}

\item{level}{Numeric (default: 0.95). The confidence level for the interval (e.g., 0.95 for a 95\% confidence interval).}
}
\value{
description A list containing:
\itemize{
\item \code{CI}: A numeric vector of length 2 with the lower and upper confidence interval bounds.
\item \code{level}: The confidence level used.
\item \code{heterogeneous_parameters}: A list with values of \code{a}, \code{kernel_name}, and \code{bandwidth} (if applicable), or \code{NULL} if a homogeneous treatment effect is estimated.
}
}
\description{
This function calculates a standard confidence interval for the estimated (potentially heterogeneous) treatment effect from a fitted \code{IVDML} object (output of \code{\link[=fit_IVDML]{fit_IVDML()}}). The confidence interval is computed using the normal approximation method using the standard error computed by \code{\link[=se]{se()}} and the treatment effect estimate from \code{\link[=coef]{coef()}}.
}
\examples{
set.seed(1)
Z <- rnorm(100)
X <- Z + rnorm(100)
H <- rnorm(100)
D <- Z^2 + sin(X) + H + rnorm(100)
A <- X
Y <- tanh(A) * D + cos(X) - H + rnorm(100)
fit <- fit_IVDML(Y = Y, D = D, Z = Z, X = X, ml_method = "gam")
standard_confint(fit, iv_method = "mlIV")
standard_confint(fit, iv_method = "mlIV", a = 0, A = A,
                 kernel_name = "boxcar", bandwidth = 0.2, level = 0.95)

}
