% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableIncidenceAttrition}
\alias{tableIncidenceAttrition}
\title{Table of incidence attrition results}
\usage{
tableIncidenceAttrition(
  result,
  type = "gt",
  header = "variable_name",
  groupColumn = c("cdm_name", "outcome_cohort_name"),
  settingsColumn = NULL,
  hide = c("denominator_cohort_name", "estimate_name", "reason_id", "variable_level"),
  style = "default"
)
}
\arguments{
\item{result}{A summarised_result object. Output of
summariseCohortAttrition().}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{colnames(omopgenerics::splitAll(result))}. Variables in \code{settingsColumn}
are also allowed}

\item{groupColumn}{Variables to use as group labels. Allowed columns are the
same as in \code{header}}

\item{settingsColumn}{Variables from the settings attribute to display in
the table}

\item{hide}{Table columns to exclude, options are the ones described in
\code{header}}

\item{style}{A style supported by visOmopResults::visOmopTable()}
}
\value{
A visual table.
}
\description{
Table of incidence attrition results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
tableIncidenceAttrition(inc)
}
}
