% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINTav.R
\name{MINTav}
\alias{MINTav}
\title{MINTav}
\usage{
MINTav(x, y, K, B = 1000)
}
\arguments{
\item{x}{The \eqn{n \times d_{X}} data matrix of the \eqn{X} values.}

\item{y}{The \eqn{n \times d_{Y}} data matrix of the \eqn{Y} values.}

\item{K}{The vector of values of \eqn{k} to be considered for estimation of the joint entropy \eqn{H(X,Y)}.}

\item{B}{The number of permutations to use for the test, set at 1000 by default.}
}
\value{
The \eqn{p}-value corresponding the independence test carried out.
}
\description{
Performs an independence test without knowledge of either marginal distribution using permutations and averaging over a range of values of \eqn{k}.
}
\examples{
\donttest{
# Independent univariate normal data
x=rnorm(1000); y=rnorm(1000);
MINTav(x,y,K=1:200,B=100)
# Dependent univariate normal data
library(mvtnorm);
data=rmvnorm(1000,sigma=matrix(c(1,0.5,0.5,1),ncol=2))  
MINTav(data[,1],data[,2],K=1:200,B=100)
# Dependent multivariate normal data
Sigma=matrix(c(1,0,0,0,0,1,0,0,0,0,1,0.5,0,0,0.5,1),ncol=4);
data=rmvnorm(1000,sigma=Sigma)
MINTav(data[,1:3],data[,4],K=1:50,B=100)
}

}
\references{
\insertRef{2017arXiv171106642B}{IndepTest}
}
