% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINTperm.R
\name{MINTperm}
\alias{MINTperm}
\title{MINTknown}
\usage{
MINTperm(x, y, k, w = FALSE, B = 1000)
}
\arguments{
\item{x}{The \eqn{n \times d_X} data matrix of \eqn{X} values.}

\item{y}{The \eqn{n \times d_Y} data matrix of \eqn{Y} values.}

\item{k}{The value of \eqn{k} to be used for estimation of the joint entropy \eqn{H(X,Y)}.}

\item{w}{The weight vector to used for estimation of the joint entropy \eqn{H(X,Y)}, with the same options as for the \code{\link{KLentropy}} function.}

\item{B}{The number of permutations to use, set at 1000 by default.}
}
\value{
The \eqn{p}-value corresponding the independence test carried out.
}
\description{
Performs an independence test without knowledge of either marginal distribution using permutations.
}
\examples{
# Independent univariate normal data
x=rnorm(1000); y=rnorm(1000)
MINTperm(x,y,k=20,B=100)
# Dependent univariate normal data
library(mvtnorm)
data=rmvnorm(1000,sigma=matrix(c(1,0.5,0.5,1),ncol=2))  
MINTperm(data[,1],data[,2],k=20,B=100)
# Dependent multivariate normal data
Sigma=matrix(c(1,0,0,0,0,1,0,0,0,0,1,0.5,0,0,0.5,1),ncol=4)
data=rmvnorm(1000,sigma=Sigma)
MINTperm(data[,1:3],data[,4],k=20,w=TRUE,B=100)

}
\references{
\insertRef{2017arXiv171106642B}{IndepTest}
}
