% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{groupIndexes}
\alias{groupIndexes}
\title{Calculate price indexes for product groups}
\usage{
groupIndexes(group, indexFunction, indexArgs)
}
\arguments{
\item{group}{the name of the variable containing the group ID. This
must be a factor variable, or a variable coercible to a factor.}

\item{indexFunction}{the name of the function to use to calculate the
index as a string. Available options are `priceIndex`, `GEKSIndex`,
`GKIndex`, `WTPDIndex`.}

\item{indexArgs}{arguments for the price index function as a named list.
All arguments must be named.}
}
\value{
a list of indexes, one for each group
}
\description{
Calculate price indexes for product groups
}
\examples{
df <- CES_sigma_2
df$groupID <- c(rep(1, 24), rep(2, 24))

argsList <- list(x = df, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", indexMethod = "fisher", output = "chained")

groupIndexes("groupID", "priceIndex", argsList)

}
