% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,IntervalData,missing-method}
\alias{plot,IntervalData,IntervalData-method}
\alias{plot,IntervalList,missing-method}
\alias{plot,IntervalList,IntervalList-method}
\title{Plot a single interval or a list of intervals}
\usage{
\S4method{plot}{IntervalData,missing}(x, y,
     layout = c("vertical", "horizontal"),
     bounds = FALSE, mid = FALSE,
     \dots)

\S4method{plot}{IntervalData,IntervalData}(x, y, bounds = FALSE, \dots)

\S4method{plot}{IntervalList,missing}(x, y,
     layout = c("vertical", "horizontal"),
     bounds = FALSE, mid = FALSE,
     \dots)

\S4method{plot}{IntervalList,IntervalList}(x, y, bounds = FALSE, \dots)
}
\arguments{
\item{x}{A single interval or a unique list with several intervals stored
as an \code{IntervalData} object or as an \code{IntervalList},
instance respectively.}

\item{y}{A single interval or a unique list with several intervals stored
as an \code{IntervalData} object or as an \code{IntervalList},
instance respectively.}

\item{layout}{The axes along which the intervals should be displayed.
Only two alternatives are allowed: \code{vertical} (default)
and \code{horizontal}.}

\item{bounds}{A single \code{logical} value indicating whether the extremes
of the given intervals should be plotted or not (default).}

\item{mid}{A single \code{logical} value indicating whether the mid-points
of the given intervals should be plotted or not (default).}

\item{\dots}{Other graphical parameters.}
}
\value{
This function does not return any value. It only plots interval-valued data.
}
\description{
S4 methods for function plot.
As in the generic plot S3 `graphics' method,
these methods plot interval-valued data contained in
both \code{IntervalData} and \code{IntervalList} objects.
}
\details{
Note that in order to get bidimensional plots with interval-valued data,
\code{x} and \code{y} arguments must be of the same class, that is, either
both are \code{IntervalData} objects or either both are \code{IntervalList}
instances. Moreover, in the second case both lists must have the same number
of intervals.
}
\examples{
## Some trivial plot() examples for IntervalData objects
i1 <- IntervalData(0, 1)
i2 <- IntervalData(2, 3)
plot(i1)                             ## Plot only an interval vertically
plot(i1, layout = "horizontal")      ## Plot only an interval horizontally
plot(i1, bounds = TRUE, mid = TRUE)  ## Add bounds and remark mid-point
plot(i1, i2)                         ## Plot an interval on each axis 
plot(i1, i2, bounds = TRUE)          ## Add bounds

## Some trivial plot() examples for IntervalList objects
list1 <- IntervalList(c(0, 3, 2, 5, 6), c(4, 5, 4, 8, 7))
list2 <- IntervalList(c(3, 0, 3, 1, 4), c(7, 4, 6, 2, 6))
plot(list1)                            ## Plot an interval list vertically
plot(list1, layout = "horizontal")     ## Plot an interval list horizontally
plot(list1, bounds = TRUE, mid = TRUE) ## Add bounds and remark mid-points
plot(list1, list2)                     ## Plot an interval list on each axis 
plot(list1, list2, bounds = TRUE)      ## Add bounds

## Further plot() customizations
plot(list1, bounds = TRUE, mid = TRUE,
     main = "My one-dimensional interval-valued plot",
     col = c("blue", "red"), lwd = 2)
plot(list1, list2, bounds = TRUE,
     main = "My bidimensional interval-valued plot",
     col = "blue", lwd = 2)
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
