% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{convexHull}
\alias{convexHull}
\title{Plots the convexhull polygon from the data (latitude, longitude), and calculates the center of the convexhull and its area.}
\usage{
convexHull(X, varOfInterest)
}
\arguments{
\item{X}{dataframe with two colums, latitute and longitude respectively.}

\item{varOfInterest}{variable of interest to plot. This variable is needed to color the points on the convexhull.}
}
\value{
A vector with two elements, the first element is the area and the second one is the centroid.
The centroid is a list of two elements, latitude and longitude that represents the centroid.
To have a visual idea of the returned object, it has the following shape \eqn{[area,[latitude,longitude], plotObject]}.
}
\description{
\code{convexHull} Computes the area and centroid of the convex hull from the (latitute, longitude) vector.
It provides a plot of how the points are dispersed in the field of interest.
}
\details{
Consideration for this function:
\itemize{
\item It makes usage of chull from rgeos and Polygon from graphics.
\item The centroid of the polygon is calculated by averaging the vertices of it.
\item The shown plot uses the basic \code{plot} command.

}
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data<-loadFile(fileInput)
area_centroid<-convexHull(data$data,data$varOfInterest)
}
