% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{getArtistAlbums}
\alias{getArtistAlbums}
\title{Get albums from an artist}
\usage{
getArtistAlbums(
  artist_id = NULL,
  artist_name = NULL,
  limit = 10,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID")
)
}
\arguments{
\item{artist_id}{Artist ID to seach for}

\item{artist_name}{Artist name to seach for}

\item{limit}{Integer to set the number of displayed search results. Maximum value is 200.}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about albums from an artist.
See \url{https://developer.jamendo.com/v3.0/artists/albums} for more information.
}
\description{
Search Jamendo database for an artist. You can search for either an artist ID or an artist name.
}
\examples{
\donttest{
##Example
 albumsFromID <- getArtistAlbums(artist_id="1510",limit=3)
 albumsFromName <- getArtistAlbums(artist_name="Judas Priestley",limit=3)
}
}
