% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{japan_birth_stats_tbl_df}
\alias{japan_birth_stats_tbl_df}
\title{Japan Birth Demographics}
\format{
A tibble with 124 observations and 51 variables:
\describe{
  \item{...1}{Index column (numeric)}
  \item{year}{Year of observation (numeric)}
  \item{birth_total}{Total number of births (numeric)}
  \item{birth_male}{Number of male births (numeric)}
  \item{birth_female}{Number of female births (numeric)}
  \item{birth_rate}{Birth rate per 1,000 population (numeric)}
  \item{birth_gender_ratio}{Male to female birth ratio (numeric)}
  \item{total_fertility_rate}{Total fertility rate (numeric)}
  \item{population_total}{Total population (numeric)}
  \item{population_male}{Male population (numeric)}
  \item{population_female}{Female population (numeric)}
  \item{infant_death_total}{Total number of infant deaths (numeric)}
  \item{infant_death_male}{Number of male infant deaths (numeric)}
  \item{infant_death_female}{Number of female infant deaths (numeric)}
  \item{infant_death_unknown_gender}{Infant deaths with unknown gender (numeric)}
  \item{infant_death_rate}{Infant mortality rate (numeric)}
  \item{infant_death_gender_ratio}{Male to female infant death ratio (numeric)}
  \item{infant_deaths_in_total_deaths}{Proportion of infant deaths in total deaths (numeric)}
  \item{stillbirth_total}{Total number of stillbirths (numeric)}
  \item{stillbirth_male}{Number of male stillbirths (numeric)}
  \item{stillbirth_female}{Number of female stillbirths (numeric)}
  \item{stillbirth_unknown_gender}{Stillbirths with unknown gender (numeric)}
  \item{stillbirth_rate}{Stillbirth rate (numeric)}
  \item{stillbirth_gender_ratio}{Male to female stillbirth ratio (numeric)}
  \item{firstborn}{Number of firstborn children (numeric)}
  \item{secondborn}{Number of secondborn children (numeric)}
  \item{thirdborn}{Number of thirdborn children (numeric)}
  \item{forthborn}{Number of fourthborn children (numeric)}
  \item{fifthborn_and_above}{Number of fifthborn and above children (numeric)}
  \item{weeks_under_28}{Births before 28 gestational weeks (numeric)}
  \item{weeks_28-31}{Births between 28 and 31 gestational weeks (numeric)}
  \item{weeks_32-36}{Births between 32 and 36 gestational weeks (numeric)}
  \item{weeks_37-41}{Births between 37 and 41 gestational weeks (numeric)}
  \item{weeks_over_42}{Births after 42 gestational weeks (numeric)}
  \item{mother_age_avg}{Average age of mothers (numeric)}
  \item{mother_age_firstborn}{Average age of mothers for firstborns (numeric)}
  \item{mother_age_secondborn}{Average age of mothers for secondborns (numeric)}
  \item{mother_age_thirdborn}{Average age of mothers for thirdborns (numeric)}
  \item{mother_age_under_19}{Births to mothers under 19 years (numeric)}
  \item{mother_age_20-24}{Births to mothers aged 20–24 (numeric)}
  \item{mother_age_25-29}{Births to mothers aged 25–29 (numeric)}
  \item{mother_age_30-34}{Births to mothers aged 30–34 (numeric)}
  \item{mother_age_35-39}{Births to mothers aged 35–39 (numeric)}
  \item{mother_age_40-44}{Births to mothers aged 40–44 (numeric)}
  \item{mother_age_over_45}{Births to mothers over 45 years (numeric)}
  \item{father_age_avg}{Average age of fathers (numeric)}
  \item{father_age_firstborn}{Average age of fathers for firstborns (numeric)}
  \item{father_age_secondborn}{Average age of fathers for secondborns (numeric)}
  \item{father_age_thirdborn}{Average age of fathers for thirdborns (numeric)}
  \item{legitimate_child}{Number of legitimate children (numeric)}
  \item{illegitimate_child}{Number of illegitimate children (numeric)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/webdevbadger/japan-birth-statistics}
}
\usage{
data(japan_birth_stats_tbl_df)
}
\description{
This dataset, japan_birth_stats_tbl_df, is a tibble containing Japan’s birth-related demographic statistics
from 1899 to 2022. The dataset includes birth counts by gender, birth rate, fertility rate, infant deaths,
stillbirths, birth order, gestational weeks, average parental ages, and legitimacy of births.
Some data are missing between the years 1944 and 1946 due to records lost during World War II.
The dataset preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'japan_birth_stats_tbl_df' to maintain consistency with the naming conventions
in the JapanAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame. The original content
has not been modified in any way.
}
