% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testKron_A.R
\name{testKron_A}
\alias{testKron_A}
\title{Testing Kronecker product structure along specified modes}
\usage{
testKron_A(ten, AA, r, alpha = c(0.01, 0.05), q = 0.05, r.exact = FALSE)
}
\arguments{
\item{ten}{An array representing an order-(K+1) tensor which is an order-K tensor time series with mode-1 being the time mode.}

\item{AA}{A vector with elements at least 1 and at most K, representing the tensor modes to test.}

\item{r}{A vector representing the rank for 'ten'.}

\item{alpha}{A vector representing the desired significance levels. Default is c(0.01, 0.05).}

\item{q}{A number between 0 and 1, representing the quantile for the decision statistic. Default is 0.05.}

\item{r.exact}{Logical. Perform the test only using 'r' if TRUE, otherwise using all divisor combinations of the last mode rank of the reshaped data. Default is FALSE.}
}
\value{
A list containing the following:
level: a matrix with each entry reporting an example test size, corresponding to its rank used (row) and level of alpha (column); the alpha is reported in order of parameter 'alpha'.
decision: a matrix with each entry reporting the decision statistic aggregated by quantile of parameter 'q', corresponding to its rank used (row) and level of alpha (column); the alpha is reported in order of parameter 'alpha'.
rank: a matrix with K columns and each row represents a different rank used, corresponding to the rows in the 'level' and 'decision' matrices.
}
\description{
Testing the Kronecker product structure of a tensor time series with a specified set of mode indices.
}
