% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_KFOLD_INDICES.R.R
\name{kfold.idx}
\alias{kfold.idx}
\title{Indices for K-fold validation}
\usage{
kfold.idx(target, k = 10, type, num.strata = 4, seed = 2191)
}
\arguments{
\item{target}{Continuous target variable.}

\item{k}{Number of folds. If \code{k} is equal or greater than the number of observations of
target variable, then validation procedure is equivalent to leave one out cross-validation (LOOCV)
method. Default is set to 10.}

\item{type}{Sampling type. Possible options are \code{"random"} and \code{"stratified"}.}

\item{num.strata}{Number of strata for \code{"stratified"} type. Default is 4.}

\item{seed}{Random seed needed for ensuring the result reproducibility. Default is 2191.}
}
\value{
The command \code{kfold.idx} returns a list of k folds estimation and validation indices.
}
\description{
\code{kfold.idx} provides indices for K-fold validation.
}
\examples{
library(monobin)
library(LGDtoolkit)
data(lgd.ds.c)
#random k-folds
kf.r <- LGDtoolkit::kfold.idx(target = lgd.ds.c$lgd, k = 5, 
			type = "random", seed = 2211)
sapply(kf.r, function(x) c(mean(lgd.ds.c$lgd[x[[1]]]), mean(lgd.ds.c$lgd[x[[2]]])))
sapply(kf.r, function(x) length(x[[2]]))
#stratified k-folds
kf.s <- LGDtoolkit::kfold.idx(target = lgd.ds.c$lgd, k = 5, 
                              type = "stratified", num.strata = 10, seed = 2211)
sapply(kf.s, function(x) c(mean(lgd.ds.c$lgd[x[[1]]]), mean(lgd.ds.c$lgd[x[[2]]])))
sapply(kf.s, function(x) length(x[[2]]))
}
