% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{RTE}
\alias{RTE}
\title{Radiative transfer equation method}
\usage{
RTE(TIR = TIR, tau = tau, E = E, dlrad = dlrad, ulrad = ulrad, band = band)
}
\arguments{
\item{TIR}{SpatRaster object, Landsat band 10 or 11}

\item{tau}{Atmospheric transmittance}

\item{E}{SpatRaster object, Land Surface Emissivity calculated according to Van de Griend and Owe 1993 or Valor and Caselles 1996 or Sobrino et al. 2008}

\item{dlrad}{Downwelling radiance calculated from https://atmcorr.gsfc.nasa.gov/}

\item{ulrad}{upwelling radiance calculated from https://atmcorr.gsfc.nasa.gov/}

\item{band}{A string specifying which Landsat 8 thermal band to use. It can be "band 10" or
"band 11"}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Temperature using radiative transfer equation method
}
\examples{
TIR <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(TIR) = runif(10000, min=27791, max=30878)
BT <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(BT) = runif(10000, min=298, max=305)
E <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(E) = runif(10000, min=0.96, max=0.99)
Ts_RTE <- RTE(TIR = TIR, tau = 0.86, E = E,
		dlrad = 2.17, ulrad = 1.30, band = "band 11")
}
\references{
Srivastava, P.K., Majumdar, T.J. and Bhattacharya, A.K., 2009. Surface temperature estimation in Singhbhum Shear Zone of India using Landsat-7 ETM+ thermal infrared data. Advances in space research, 43(10), pp.1563-1574.
}
