% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSVAR.R
\name{summary.LSVAR}
\alias{summary.LSVAR}
\title{Summary of LSVAR S3 class}
\usage{
\method{summary}{LSVAR}(object, threshold = 0.2, ...)
}
\arguments{
\item{object}{the S3 class object of \code{LSVAR}}

\item{threshold}{the threshold for sparse component visualization}

\item{...}{not in use}
}
\value{
A series of summary for the S3 result
}
\description{
summary function for S3 class for the fitting result
}
\examples{
n <- 300
p <- 20
try <- testVAR(n, p, struct = "LS", signal = 0.75, rank = 2,
               singular_vals = c(1, 0.8))
data <- as.matrix(try$series)
lambda <- 0.1; mu <- 1
fit <- fista.LpS(data, lambda = lambda, mu = mu, x.true = try$model_param)
summary(fit, threshold = 0.2)
}
