% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getwaveletbasis.R
\name{get.wavelet.basis}
\alias{get.wavelet.basis}
\title{Wavelet Packet indices for a Wavelet Basis}
\usage{
get.wavelet.basis(scale)
}
\arguments{
\item{scale}{The maximum scale for which the indices of the wavelet basis are returned.
Tipically this is a positive integer.}
}
\value{
A matrix of two columns where each row refers to a different selected packet.
The first index refers to each given scale, the second index refers to the packet
within this level.
}
\description{
\code{get.wavelet.basis} returns the full set of packet indices relative to a wavelet basis
selected from the wavelet packet table.
}
\details{
This function is used internally by other routines but it might be useful when
the 'classical' wavelet spectral estimation is of interest. The function returns
an object of class \code{LSWPbasis}, whose structure is the same to the object produced by
\code{\link{best.basis}}.
}
\examples{
get.wavelet.basis(scale = 4)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{best.basis}}, \code{\link{get.flat.basis}}
}
\author{
Alessandro Cardinali
}
