% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SSB.R
\name{plot_SSB}
\alias{plot_SSB}
\alias{plot_SSB,LeMans_param,LeMans_outputs-method}
\alias{plot_SSB,LeMans_param,missing-method}
\alias{plot_SSB,missing,LeMans_outputs-method}
\alias{plot_SSB,missing,missing-method}
\alias{plot_biomass}
\alias{plot_biomass,LeMans_param,LeMans_outputs-method}
\alias{plot_biomass,LeMans_param,missing-method}
\alias{plot_biomass,missing,LeMans_outputs-method}
\alias{plot_biomass,missing,missing-method}
\title{Plot Spawning Stock Biomass (SSB)}
\usage{
plot_SSB(inputs, outputs, ...)

\S4method{plot_SSB}{LeMans_param,LeMans_outputs}(inputs, outputs, species, time_steps, species_names, SSB, ...)

\S4method{plot_SSB}{LeMans_param,missing}(inputs, N, species, time_steps, species_names, SSB, ...)

\S4method{plot_SSB}{missing,LeMans_outputs}(wgt, mature, outputs, species, time_steps, species_names, SSB, ...)

\S4method{plot_SSB}{missing,missing}(
  wgt,
  mature,
  N,
  species,
  species_names,
  time_steps,
  SSB,
  full_plot_only = TRUE,
  units = "g",
  ...
)

plot_biomass(inputs, outputs, ...)

\S4method{plot_biomass}{LeMans_param,LeMans_outputs}(inputs, outputs, species, time_steps, species_names, biomass, ...)

\S4method{plot_biomass}{LeMans_param,missing}(inputs, N, species, time_steps, biomass, species_names, ...)

\S4method{plot_biomass}{missing,LeMans_outputs}(wgt, outputs, species, time_steps, biomass, species_names, ...)

\S4method{plot_biomass}{missing,missing}(
  wgt,
  N,
  species,
  time_steps,
  species_names,
  biomass,
  full_plot_only = TRUE,
  units = "g",
  ...
)
}
\arguments{
\item{inputs}{A \code{\linkS4class{LeMans_param}} object containing the parameter values of the current LeMans model. This option is only required if \code{SSB} is not provided.}

\item{outputs}{A \code{\linkS4class{LeMans_outputs}} object containing the outputs of the model run. This option is only required if \code{SSB} is not provided.}

\item{...}{Additional arguments.}

\item{species}{A numeric value or vector or a character string or vector denoting the species to be used in the plot(s). The default is \code{1:dim(N)[2]}.}

\item{time_steps}{A numeric vector denoting the time steps to be used to calculate and/or plot SSB. The default is \code{1:dim(N)[3]} or \code{1:length(SSB)}.}

\item{species_names}{A character vector of length \code{1:dim(N)[2]} that denotes the names of the species in the model. This option is only required if \code{inputs} is not provided.}

\item{SSB}{A numeric vector or a matrix representing the outputs of the function \code{get_SSB()}. This option is only required if \code{inputs} and \code{outputs} are not provided.}

\item{N}{An array with dimensions \code{nsc}, \code{nfish} and \code{tot_time} representing the number of individuals in each length class for each time step, where \code{nsc} represents the number of length classes in the model, \code{nfish} represents the number of species in the model and \code{tot_time} represents the number of time steps that the model was run for. This option is only required if \code{outputs} and \code{SSB} are not provided.}

\item{wgt}{A matrix with dimensions \code{nsc} and \code{nfish} representing the weight of each species in each length class. This option is only required if \code{inputs} and \code{SSB} are not provided.}

\item{mature}{A matrix with dimensions \code{nsc} and \code{nfish} and elements in the range 0-1 representing the proportion of individuals that are mature for each species and length class, where \code{nsc} represents the number of length classes in the model and \code{nfish} represents the number of species in the model. This option is only required if \code{outputs} and \code{SSB} are not provided.}

\item{full_plot_only}{A logical statement indicating whether a single plot depicting the SSB of all of the selected species should be produced (\code{full_plot_only=TRUE}) or multiple plots depicting the SSB of individual species should be produced (\code{full_plot_only=FALSE}). The default is \code{TRUE}.}

\item{units}{A character string denoting the units of weight used in the model. The default is \code{"g"}.}

\item{biomass}{A numeric vector or a matrix representing the outputs of the function \code{get_biomass()}. This option is only required if \code{inputs} and \code{outputs} are not provided.}
}
\value{
\code{plot_SSB} returns line plots of the in SSB of the selected species through time.

\code{plot_biomass} returns line plots of the changes in biomass of the selected species through time.
}
\description{
Plots community and/or species-specific Spawning Stock Biomass (SSB) or total biomass.
}
\examples{
# Set up and run the model
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=1e12)
effort <- matrix(0.5, 10, dim(NS_params@Qs)[3])
model_run <- run_LeMans(NS_params, years=10, effort=effort)

# Calculate SSB
SSB <- get_SSB(NS_params, model_run)

# Plot SSB
plot_SSB(SSB=SSB)

# Calculate biomass
biomass <- get_biomass(NS_params, model_run)

# Plot biomass
plot_biomass(biomass=biomass)
}
\seealso{
\code{\link{get_SSB}}, \code{\link{get_biomass}}
}
