% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_indicators.R
\name{plot_indicators}
\alias{plot_indicators}
\alias{plot_indicators,LeMans_param,LeMans_outputs-method}
\alias{plot_indicators,LeMans_param,missing-method}
\alias{plot_indicators,missing,LeMans_outputs-method}
\alias{plot_indicators,missing,missing-method}
\alias{plot_LFI}
\alias{plot_LFI,LeMans_param,LeMans_outputs-method}
\alias{plot_LFI,LeMans_param,missing-method}
\alias{plot_LFI,missing,LeMans_outputs-method}
\alias{plot_LFI,missing,missing-method}
\alias{plot_MML}
\alias{plot_MML,LeMans_param,LeMans_outputs-method}
\alias{plot_MML,LeMans_param,missing-method}
\alias{plot_MML,missing,LeMans_outputs-method}
\alias{plot_MML,missing,missing-method}
\alias{plot_TyL}
\alias{plot_TyL,LeMans_param,LeMans_outputs-method}
\alias{plot_TyL,LeMans_param,missing-method}
\alias{plot_TyL,missing,LeMans_outputs-method}
\alias{plot_TyL,missing,missing-method}
\alias{plot_LQ}
\alias{plot_LQ,LeMans_param,LeMans_outputs-method}
\alias{plot_LQ,LeMans_param,missing-method}
\alias{plot_LQ,missing,LeMans_outputs-method}
\alias{plot_LQ,missing,missing-method}
\title{Plot indicators}
\usage{
plot_indicators(inputs, outputs, ...)

\S4method{plot_indicators}{LeMans_param,LeMans_outputs}(inputs, outputs, species, time_steps, prob, length_LFI, ...)

\S4method{plot_indicators}{LeMans_param,missing}(inputs, N, species, time_steps, prob, length_LFI, ...)

\S4method{plot_indicators}{missing,LeMans_outputs}(
  wgt,
  mid,
  l_bound,
  u_bound,
  Linf,
  species,
  outputs,
  time_steps,
  species_names = NULL,
  prob,
  length_LFI,
  ...
)

\S4method{plot_indicators}{missing,missing}(
  wgt,
  mid,
  l_bound,
  u_bound,
  Linf,
  N,
  species,
  time_steps,
  species_names = NULL,
  prob,
  length_LFI,
  MML,
  TyL,
  LFI,
  LQ,
  units = "cm",
  ...
)

plot_LFI(inputs, outputs, ...)

\S4method{plot_LFI}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species,
  time_steps,
  species_names,
  length_LFI,
  LFI,
  ...
)

\S4method{plot_LFI}{LeMans_param,missing}(inputs, N, species, time_steps, species_names, length_LFI, LFI, ...)

\S4method{plot_LFI}{missing,LeMans_outputs}(
  wgt,
  l_bound,
  u_bound,
  outputs,
  species,
  time_steps,
  species_names,
  length_LFI,
  LFI,
  ...
)

\S4method{plot_LFI}{missing,missing}(
  wgt,
  l_bound,
  u_bound,
  N,
  species,
  time_steps,
  species_names,
  length_LFI,
  LFI,
  units = "cm",
  ...
)

plot_MML(inputs, outputs, ...)

\S4method{plot_MML}{LeMans_param,LeMans_outputs}(inputs, outputs, species, species_names, time_steps, MML, ...)

\S4method{plot_MML}{LeMans_param,missing}(inputs, N, species, time_steps, species_names, MML, ...)

\S4method{plot_MML}{missing,LeMans_outputs}(wgt, Linf, outputs, species, time_steps, species_names, MML, ...)

\S4method{plot_MML}{missing,missing}(
  wgt,
  Linf,
  N,
  species,
  time_steps,
  species_names,
  MML,
  units = "cm",
  ...
)

plot_TyL(inputs, outputs, ...)

\S4method{plot_TyL}{LeMans_param,LeMans_outputs}(inputs, outputs, species, time_steps, species_names, TyL, ...)

\S4method{plot_TyL}{LeMans_param,missing}(inputs, N, species, time_steps, species_names, TyL, ...)

\S4method{plot_TyL}{missing,LeMans_outputs}(wgt, mid, outputs, species, time_steps, species_names, TyL, ...)

\S4method{plot_TyL}{missing,missing}(
  wgt,
  mid,
  N,
  species,
  time_steps,
  species_names,
  TyL,
  units = "cm",
  ...
)

plot_LQ(inputs, outputs, ...)

\S4method{plot_LQ}{LeMans_param,LeMans_outputs}(inputs, outputs, species, time_steps, species_names, LQ, prob, ...)

\S4method{plot_LQ}{LeMans_param,missing}(inputs, N, species, species_names, time_steps, LQ, prob, ...)

\S4method{plot_LQ}{missing,LeMans_outputs}(
  wgt,
  u_bound,
  outputs,
  species,
  time_steps,
  species_names,
  LQ,
  prob,
  ...
)

\S4method{plot_LQ}{missing,missing}(
  wgt,
  u_bound,
  N,
  species,
  time_steps,
  species_names,
  LQ,
  prob,
  units = "cm",
  ...
)
}
\arguments{
\item{inputs}{A \code{\linkS4class{LeMans_param}} object containing the parameter values of the current LeMans model.}

\item{outputs}{A \code{\linkS4class{LeMans_outputs}} object containing the outputs of the model run.}

\item{...}{Additional arguments.}

\item{species}{A numeric value or vector or a character string or vector denoting the species to be used to calculate the indicators. This option is only required if \code{MML}, \code{LFI}, \code{TyL} and \code{LQ} are not provided. The default is \code{1:dim(N)[2]}.}

\item{time_steps}{A numeric vector denoting the time steps to be used to calculate and/or plot the indicators. The default is \code{1:dim(N)[3]} or \code{1:length(indicator)}.}

\item{prob}{A numeric value or vector between 0 and 1 denoting the LQ(s) to be calculated. This option is only required if \code{LQ} is not provided. The default is \code{0.5}.}

\item{length_LFI}{A numeric value or vector representing the threshold(s) to be used to calculate the LFI. This option is only required if \code{LFI} is not provided. The default is \code{40}.}

\item{N}{An array with dimensions \code{nsc}, \code{nfish} and \code{tot_time} representing the number of individuals in each length class for each time step, where \code{nsc} represents the number of length classes in the model, \code{nfish} represents the number of species in the model and \code{tot_time} represents the number of time steps that the model was run for. This option is only required if \code{outputs} or \code{MML}, \code{LFI}, \code{TyL} and \code{LQ} are not provided.}

\item{wgt}{A matrix with dimensions \code{nsc} and \code{nfish} representing the weight of each species in each length class. This option is only required if \code{inputs} or \code{MML}, \code{LFI}, \code{TyL} and \code{LQ} are not provided.}

\item{mid}{A numeric vector of length \code{nfish} representing the mid-point of the length classes in the model, where \code{nfish} represents the number of species in the model. This option is only required if \code{inputs} or \code{TyL} are not provided.}

\item{l_bound}{A numeric vector of length \code{nsc} representing the lower bounds of the length classes, where \code{nsc} represents the number of length classes in the model. This option is only required if \code{inputs} or \code{LFI} are not provided.}

\item{u_bound}{A numeric vector of length \code{nsc} representing the upper bounds of the length classes, where \code{nsc} represents the number of length classes in the model. This option is only required if \code{inputs}, \code{LFI} and/or \code{LQ} are not provided.}

\item{Linf}{A numeric vector of length \code{nfish} representing the asymptotic length of each species, where \code{nfish} represents the number of species in the model. This option is only required if \code{inputs} or \code{MML} are not provided.}

\item{species_names}{A character vector of length \code{1:dim(N)[2]} that denotes the names of the species in the model. This option is only required if \code{inputs} is not provided.}

\item{MML}{A numeric vector representing the outputs of the function \code{get_MML()}. This option is only required if \code{inputs} and \code{outputs} are not provided.}

\item{TyL}{A numeric vector representing the outputs of the function \code{get_TyL()}. This option is only required if \code{inputs} and \code{outputs} are not provided.}

\item{LFI}{A numeric vector or matrix representing the outputs of the function \code{get_LFI()}. This option is only required if \code{inputs} and \code{outputs} are not provided.}

\item{LQ}{A numeric vector or matrix representing the outputs of the function \code{get_LQ()}. This option is only required if \code{inputs} and \code{outputs} are not provided.}

\item{units}{A character string denoting the units of length used in the model. The default is \code{"cm"}.}
}
\value{
\code{plot_indicators} returns a set of four line plots depicting changes in the MML, LFI, TyL and LQ(s) of the community (including only the selected species) over time.

\code{plot_LFI} returns a line plot depicting the LFI of the community (including only the selected species) over time.

\code{plot_MML} returns a line plot depicting the MML of the community (including only the selected species) over time.

\code{plot_TYL} returns a line plot depicting the TyL of the community (including only the selected species) over time.

\code{plot_LQ} returns a line plot depicting the LQ(s) of the community (including only the selected species) over time.
}
\description{
Plots Mean Maximum Length (MML), the Large Fish Indicator (LFI), Typical Length (TyL) and the Length Quantiles (LQ) of the whole community or a subset of the species.
}
\examples{
# Set up and run the model
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=1e12)
effort <- matrix(0.5, 10, dim(NS_params@Qs)[3])
model_run <- run_LeMans(NS_params, years=10, effort=effort)

# Calculate the indicators
tmp <- get_indicators(NS_params, model_run)
MML <- tmp$MML
LFI <- tmp$LFI
TyL <- tmp$TYL
LQ <- tmp$LQ

# Plot the indicators
plot_indicators(MML=MML, LFI=LFI, TyL=TyL, LQ=LQ)

# Plot the LFI
plot_LFI(LFI=LFI)

# Plot MML
plot_MML(MML=MML)

# Plot the TyL
plot_TyL(TyL=TyL)

# Plot the LQs
plot_LQ(LQ=LQ)
}
\seealso{
\code{\link{get_indicators}}
}
