% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_triangle_data.R
\name{tidy_triangle_data}
\alias{tidy_triangle_data}
\title{Tidy triangular data (Lexis triangles)}
\usage{
tidy_triangle_data(triangle_data, source = "HMD")
}
\arguments{
\item{triangle_data}{data.frame, A data.frame containing raw triangle data.}

\item{source}{character, The source of the raw data. Supported sources: HMD.}
}
\value{
A data.frame.
}
\description{
Take raw data from a data source (e.g. Human Mortality Database) and make it 'tidy'.
}
\details{
When using raw triangular data from HMD or other sources, the data is not well prepared for further use. \code{tidy_triangular_data} does some transformations to prepare the data, mainly for visualization using \code{ggplot2}.
}
\examples{
\dontrun{
triangles <- readHMDweb("RUS", "Deaths_lexis", "your@email.com", "your_password")
}
}
\author{
Philipp Ottolinger
}
