% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvivalCurve.R
\name{plotSurvivalCurve}
\alias{plotSurvivalCurve}
\title{Survival curve for the Life and Fertility Table}
\usage{
plotSurvivalCurve(object)
}
\arguments{
\item{object}{\code{object} accepts 2 classes of objects:
\itemize{
\item{An object inheriting from \code{\link[=lifertable]{lifertable()}}, representing the
Life and Fertility Table.}
\item{An object of class \code{lifertableLFT} inherited from \code{\link[=lifertable]{lifertable()}}.
This is the object that displays the Life and Fertility Table.}
}}
}
\value{
Returns an object of \code{\link[base:class]{class}} c("gg", "ggplot").
}
\description{
This function generates the graphical representation of the Life Table.
Survival (y-axis) versus Age (x-axis)
}
\examples{
## The main object will be created using the Insects database:
lft <- lifertable(ColumnFemale = Female,
                  ColumnAge = Age,
                  ColumnEggs = Eggs,
                  SexRate = Sexrate,
                  ColumnGroups = Group,
                  data = Insects)

## Possible usage scenarios

## 1. Direct Usage of the "lft" Object:
plotSurvivalCurve(lft)

## 2. Assigning the component "LIFERTABLE" to an object:
lifeTable <- lft$LIFERTABLE
plotSurvivalCurve(lifeTable)

## 3. Direct usage of the component:
plotSurvivalCurve(lft$LIFERTABLE)



}
