% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_metric.R
\name{extract_metric}
\alias{extract_metric}
\title{Add metrics to extracted sSummary}
\usage{
extract_metric(
  extracted_data,
  data,
  identifying.colname = state.count,
  Datetime.colname = Datetime,
  ...
)
}
\arguments{
\item{extracted_data}{A dataframe containing cluster or state summaries,
typically from \code{extract_clusters()} or \code{extract_states()}.}

\item{data}{The original dataset that produced \code{extracted_data}}

\item{identifying.colname}{Name of the column in \code{extracted_data} that
uniquely identifies each row (in addition to the groups. Expects a symbol.
Defaults to \code{state.count}}

\item{Datetime.colname}{Column name that contains the datetime in \code{data}.
Defaults to "Datetime" which is automatically correct for data imported
with LightLogR. Expects a symbol. This argument is only necessary if \code{data}
does not contain the \code{cluster.colname}.}

\item{...}{Arguments specifying the metrics to add summary. For example:
\code{"mean_lux" = mean(lux)}.}
}
\value{
A dataframe containing the extracted data with added metrics.
}
\description{
This helper function adds metric values to an extract, like from
\code{\link[=extract_states]{extract_states()}} or \code{\link[=extract_clusters]{extract_clusters()}}. E.g., the average value of a
variable during a cluster or state instance might be of interest. The metrics
must be specified by the user using the \code{...} argument.
}
\details{
The original \code{data} does not have to have the cluster/state information, but
it will be computationally faster if it does.
}
\examples{
# Extract clusters and add mean MEDI value
sample.data.environment |>
filter_Date(length = "2 days") |> 
extract_clusters(MEDI > 1000) |>
extract_metric(
  sample.data.environment,
  "mean_medi" = mean(MEDI, na.rm = TRUE)
) |>
dplyr::select(Id, state.count, duration, mean_medi)

# Extract states and add mean MEDI value
dataset <-
sample.data.environment |>
filter_Date(length = "2 days") |> 
 add_photoperiod(c(48.5, 9))

dataset |>
  extract_states(photoperiod.state) |>
  extract_metric(dataset, mean_lux = mean(MEDI)) |>
  dplyr::select(state.count, duration, mean_lux)
}
