% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{gap_finder}
\alias{gap_finder}
\title{Check for and output gaps in a dataset}
\usage{
gap_finder(
  dataset,
  Datetime.colname = Datetime,
  epoch = "dominant.epoch",
  gap.data = FALSE,
  silent = FALSE,
  full.days = FALSE
)
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{epoch}{The epoch to use for the gapless sequence. Can be either a
\code{lubridate::duration()} or a string. If it is a string, it needs to be
either '"dominant.epoch"' (the default) for a guess based on the data or a
valid \code{lubridate::duration()} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{gap.data}{Logical. If \code{TRUE}, returns a \code{tibble} of the gaps in the
dataset. Default is \code{FALSE}.}

\item{silent}{Logical. If \code{TRUE}, suppresses the message with the summary of
the gaps in the dataset. Default is \code{FALSE}. Only used for unit tests.}

\item{full.days}{If \code{TRUE}, the gapless sequence will include the whole first
and last day where there is data.}
}
\value{
Prints message with a short summary of the gaps in the dataset. If
\code{gap.data = TRUE}, returns a \code{tibble} of the gaps in the dataset.
}
\description{
Quickly check for implicit missing \code{Datetime} data. Outputs a message with a
short summary, and can optionally return the gaps as a \code{tibble}. Uses
\code{gap_handler()} internally.
}
\details{
The \code{gap_finder()} function is a wrapper around \code{gap_handler()} with the
\code{behavior} argument set to \code{"gaps"}. The main difference is that
\code{gap_finder()} returns a message with a short summary of the gaps in the
dataset, and that the \code{tibble} with the gaps contains a column \code{gap.id} that
indicates the gap number, which is useful to determine, e.g., the consecutive
number of gaps between measurement data.
}
\examples{
dataset <-
tibble::tibble(Id = c("A", "A", "A", "B", "B", "B"),
              Datetime = lubridate::as_datetime(1) +
                         lubridate::days(c(0:2, 4, 6, 8)) +
                         lubridate::hours(c(0,12,rep(0,4)))) \%>\%
dplyr::group_by(Id)
dataset

#look for gaps assuming the epoch is the dominant epoch of each group
gap_finder(dataset)

#return the gaps as a tibble
gap_finder(dataset, gap.data = TRUE)

#assuming the epoch is 1 day, we have different gaps, and the datapoint at noon is now `irregular`
gap_finder(dataset, epoch = "1 day")
}
\seealso{
Other regularize: 
\code{\link{dominant_epoch}()},
\code{\link{extract_gaps}()},
\code{\link{gap_handler}()},
\code{\link{gapless_Datetimes}()},
\code{\link{has_gaps}()},
\code{\link{has_irregulars}()}
}
\concept{regularize}
