% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_equiv.R
\name{descriptive_equiv}
\alias{descriptive_equiv}
\title{descriptive_equiv function}
\usage{
descriptive_equiv(data_a, data_b, formula, delta, alpha = 0.05)
}
\arguments{
\item{data_a}{dataset \eqn{X_A} for model \eqn{M_A}}

\item{data_b}{dataset \eqn{X_B} for model \eqn{M_B}}

\item{formula}{logistic regression formula}

\item{delta}{equivalence sensitivity level \eqn{\delta_\beta}}

\item{alpha}{significance level \eqn{\alpha} (defaults to 0.05)}
}
\value{
\describe{
  \item{\code{equivalence}}{ the \code{beta_equivalence} function output}
  \item{\code{model_a}}{ logistic regression model \eqn{M_A}}
  \item{\code{model_b}}{ logistic regression model \eqn{M_B}}
}
}
\description{
This function takes two datasets \eqn{X_A, X_B}, regression formula,
    significance level \eqn{\alpha} and sensitivity level
    \eqn{\delta_\beta} (either vector or scalar). It builds a logistic
    regression model for each of the datasets and then checks whether the
    obtained coefficient vectors are equivalent, using the
    \code{beta_equivalence} function.
}
