% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unanchored_maic.R
\name{unanchored_maic}
\alias{unanchored_maic}
\title{Conduct non-Anchored Matching-Adjusted Indirect Comparison (MAIC).}
\arguments{
\item{unds_wts}{A combined data frame containing individual efficacy data
from the intervention study and pseudo efficacy data from the comparator
study.}

\item{unds.arm}{The name of the grouping column in the combined data frame
specified by \emph{unds_wts}, e.g., comparator.arm = TRT. The default is TRT.}

\item{comparator.study}{A character specifying or presenting the comparator
study, e.g., comparator.study = "Study XX-1".}

\item{unds.param.var}{The name of the column that specifies only a subset
of the rows of the data to be used.}

\item{unds.param}{A character specifying the subset of the rows to be used.
This is the value of the column set by the \emph{unds.param.var}.}

\item{time}{The name of the survival or follow up time column in the
combined data frame.}

\item{status}{The status indicator, normally 0 = event, 1 = censored.
Can be reseted using the \emph{event} parameter.}

\item{event}{A numeric value that represents the survival status, 0 = event,
1 = censored.}

\item{response}{The name of the response status column in the \emph{unds_wts}.}

\item{dtype}{Two options are available: "HR" and "OR". The default is "HR".}

\item{wt.col}{The name of the estimated weights column in the data frame
specified by \emph{unds_wts}. The default is wt.}

\item{CIw}{The numeric value specifying the width of the confidence interval,
with a default of 0.95.}

\item{digits}{Specify the number of decimal places for the output results.}
}
\value{
A data frame containing the non-anchored matching-adjusted indirect
comparison results.
}
\description{
Conduct non-Anchored Matching-Adjusted Indirect Comparison (MAIC).
}
\examples{
\donttest{
results3 <- unanchored_maic(
  unds_wts = unpts, unds.arm = ARM,
  comparator.study = "Study XX-1",
  unds.param.var = PARAMCD, unds.param = "OS",
  time = AVAL, status = CNSR, event = 0,
  dtype = "HR")

results3

results4 <- unanchored_maic(
  unds_wts = unpts, unds.arm = ARM,
  #' unds.param = "ORR",
  #' comparator.study = "Study XX-1",
  response = CNSR,
  dtype = "OR")

results4
}

}
