% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMCMCtree.R
\name{readMCMCtree}
\alias{readMCMCtree}
\title{Read MCMCtree output tree into R}
\usage{
readMCMCtree(inputPhy, forceUltrametric = TRUE, from.file = TRUE)
}
\arguments{
\item{inputPhy}{file directory of 'Figtree' output from MCMCtree}

\item{forceUltrametric}{alters branch lengths at tips so tree is fully ultrametric (default = TRUE)}

\item{from.file}{Logical. Read a tree from file or locally from within R?}
}
\value{
apePhy time-scaled output tree from MCMCtree in APE format

nodeAges mean and 95% Equal-tail CI ages for each node on the tree
}
\description{
Read MCMCtree output tree into R to produce time-scaled tree in APE format, and a table of the mean and 95% Highest Posterior Density
}
\examples{
data(MCMCtree.output)
attach(MCMCtree.output)
# tree and node ages
readMCMCtree(MCMCtree.phy, from.file=FALSE)
}
\author{
Mark Puttick
}
