% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCTrend.R
\name{MCTrend}
\alias{MCTrend}
\title{Monte Carlo Trend Analysis}
\usage{
MCTrend(x, n_rep, plot_title, int = 0.25, opt)
}
\arguments{
\item{x}{A data frame containing the input data. The first raw expected to contain model names or time series names.}

\item{n_rep}{Number of replications for the Monte Carlo simulation.}

\item{plot_title}{Title for the plot.}

\item{int}{A number indicating lower threshold value of the interval within which no trend is defined, the upper value is calculated based on this value, by default a lower value of 0.25 is considered.}

\item{opt}{A number indicating type of results, for opt = 1 returns test result, opt = 2 returns plot}
}
\value{
A data frame and a plot containing results of the trend analysis.
}
\description{
This function performs Monte Carlo trend analysis on input data and generates plots.
}
\examples{

  # file for example
  file <- MCTrend::example

  # Apply the test
  MCTrend::MCTrend(x = file, n_rep = 100, plot_title = 'Precipitaciones', int = 0.1, opt = 1)

  # plot of the result of the test
  MCTrend::MCTrend(x = file, n_rep = 100, plot_title = 'Precipitaciones', int = 0.1, opt = 2)

}
