#' An example of joined national forest inventory data, site descriptors, and
#' climate data that is used as a fitting data frame for mortality sub model
#'
#' This is simulated data that reassemble the national forest inventory data.
#' We use it to show how to run examples for mortality sub model
#'
#' @format A data frame with 6394 rows and 25 variables:
#' \describe{
#'   \item{plotID}{a unique identifier for plot}
#'   \item{treeID}{a unique identifier for tree}
#'   \item{year}{year in which plot was visited}
#'   \item{speciesGroup}{identifier for species group}
#'   \item{code}{status of a tree: 0 (normal), 1(harvested), 2(dead), 3 (ingrowth)}
#'   \item{species}{species name}
#'   \item{height}{tree height in meters}
#'   \item{crownHeight}{crown height in meters}
#'   \item{protected}{logical, 1 if protected, otherwise 0}
#'   \item{slope}{slope on a plot}
#'   \item{elevation}{plot elevation}
#'   \item{northness}{plot northness, 1 is north, 0 is south}
#'   \item{siteIndex}{a proxy for site index, higher value represents more productive sites}
#'   \item{BA}{basal area of individual trees in m2}
#'   \item{weight}{upscale weight to calculate hectare values}
#'   \item{stand_BA}{Total stand basal area}
#'   \item{stand_n}{The number of trees in a stand}
#'   \item{BAL}{Basal Area in Large trees}
#'   \item{p_BA}{basal area of individual trees in m2 from previous simulation step}
#'   \item{p_height}{tree height in meters from previous simulation step}
#'   \item{p_crownHeight}{crown height in meters from previous simulation step}
#'   \item{p_weight}{upscale weight to calculate hectare values from previous simulation step}
#'   \item{BAI}{basal area increment}
#'   \item{p_sum}{monthly precipitation sum}
#'   \item{t_avg}{monthly mean temperature}
#' }
#' @export
"data_mortality"
