% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_pfi_results}
\alias{table_pfi_results}
\title{Permutation Feature Importance Results Table}
\usage{
table_pfi_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'sensitivity_analysis(methods = "PFI")'.}

\item{show_table}{Boolean. Whether to print the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with PFI
results.
}
\description{
The \strong{table_pfi_results()} function extracts Permutation Feature Importance
results, a model-agnostic technique that evaluates variable importance
through performance degradation when randomly permuting each feature's values.
}
\examples{
# Note: For obtaining the table with PFI method results the user needs
# to complete till sensitivity_analysis() function of the
# MLwrap pipeline using the PFI method.
# See the full pipeline example under sensitivity_analysis
# (Requires sensitivity_analysis(methods = "PFI"))
# Final call signature:
# table_pfi_results(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
