#' @title Closing Stock Price of Apple Inc.
#'
#' @description A data set containing the closing price of Apple Inc. Stock, from January 1981 to December 2014
#'
#' @docType data
#' @name AAPLStockMonthly
#' @usage data(AAPLStockMonthly)
#' @details
#'   A data frame with 408 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (months since January 1981)
#'     \item{\code{AdjClose}} (adjusted closing price of Apple Inc. stock)
#'   }
#'
#' @source
#' Yahoo Finance
#'
#' @references
#' http://finance.yahoo.com/q/hp?s=AAPL&a=11&b=12&c=1980&d=06&e=2&f=2014&g=m
#'
#' @examples
#' data(APPLStockMontly)
#'

NA

#' @title Number of Students taking the AP Calculus Exam
#'
#' @description A data set containing the number of students who have taken the AP Calculus exam from 1955 to 2015.
#'
#' @docType data
#' @name APCalculus
#' @usage data(APCalculus)
#' @details
#'   A data frame with 61 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Exams}} (number of AP exams taken in associated year)
#'   }
#'
#' @source
#' Personal correspondence with Stephen M. Kokoska.
#'
#' @examples
#' data(APCalculus)
#'

NA


#' @title Number of Students taking the AP Calculus Exam
#'
#' @description A subset of the data set \code{APCalculus} containing the number of students who have taken the AP Calculus exam from 1955 to 2015.
#'
#' @docType data
#' @name APCalculus2
#' @usage data(APCalculus2)
#' @details
#'   A data frame with 38 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Exams}} (number of AP exams taken in associated year)
#'   }
#'
#' @source
#' Personal correspondence with Stephen M. Kokoska.
#'
#' @examples
#' data(APCalculus2)
#'

NA

#'
#' @title Blast Radius of Trinity Test
#'
#' @description A data set containing the blast radius (in meters) as a function of time (in seconds) for the Trinity
#' test conducted by the United States in White Sands, New Mexico in 1945.
#'
#' @docType data
#' @name BlastData
#' @usage data(BlastData)
#' @details
#'   A data frame with 23 observations on the following variables.
#'   \itemize{
#'     \item{\code{time}} (in seconds)
#'     \item{\code{radius}} (in meters)
#'   }
#'
#' @source
#' Taylor, G. “The Formation of a Blast Wave by a Very Intense Explosion. II. The Atomic Explosion
#' of 1945.” \emph{Proceedings of the Royal Society A: Mathematical, Physical and Engineering Sciences},
#' 1950, 201: 175–86.
#'
#' @examples
#' data(BlastData)
#'

NA

#' @title Closing Stock Price of Apple Inc.
#'
#' @description A data set containing the field metablic rate of individual birds and mammals (measured in
#' kilojoules per day) as a function of its body mass (in kilograms)
#'
#' @docType data
#' @name BodyMassMetabolicRate
#' @usage data(BodyMassMetabolicRate)
#' @details
#'   A data frame with 1498 observations on the following variables.
#'   \itemize{
#'     \item{\code{Mass}} (in kilograms)
#'     \item{\code{Rate}} (field metabolic rate in kilojoules per day)
#'   }
#'
#' @source
#' Hudson, L. N., Isaac, N. J. B., Reuman, D. C. (2013), The relationship between body mass and
#' field metabolic rate among individual birds and mammals. \emph{Journal of Ecology}, 82: 1009-1020.
#' doi: 10.1111/1365-2656.12086.
#'
#' @references
#' http://onlinelibrary.wiley.com/doi/10.1111/1365-2656.12086/suppinfo
#'
#' @examples
#' data(BodyMassMetabolicRate)
#'

NA

#' @title Quarterly Closing Value of Dow Jones Industrial Average
#'
#' @description A data set containing the quarterly closing value of the Dow Jones Industrial Average (DJIA) from
#' March 31, 1935 to December 31, 2014.
#'
#' @docType data
#' @name DJIACloseQuarterly
#' @usage data(DJIACloseQuarterly)
#' @details
#'   A data frame with 320 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since March 31, 1935)
#'     \item{\code{Close}} (Closing value of DJIA)
#'   }
#'
#' @source
#'Closing stock market value of the Dow Jones Industrial Average at the end of each quarter from
#'March 31, 1930 through December 31, 2014 from “^DJI — Nasdaq Composite — U.S. — Stooq.”
#'Accessed on July 7, 2015.
#'
#' @references
#' http://stooq.com/q/d/?s=^dji
#'
#' @examples
#' data(DJIACloseQuarterly)
#'

NA

#' @title Ebola Cases in Sierra Leone, Africa
#'
#' @description A data set containing the cummulative number of ebola cases in Sierra Leone, Africa from
#' May 1, 2014 to December 16, 2015
#'
#' @docType data
#' @name EbolaSierraLeone
#' @usage data(EbolaSierraLeone)
#' @details
#'   A data frame with 110 observations on the following variables.
#'   \itemize{
#'     \item{\code{Day}} (since May 1, 2014)
#'     \item{\code{Cases}} (cummulative number of ebola cases)
#'   }
#'
#' @source
#' Ebola Outbreak in West Africa from Centers for Disease Control and Preven- tion. Accessed on
#' June 2, 2016.
#'
#' @references
#' http://www.cdc.gov/vhf/ebola/outbreaks/2014-west-africa/cumulative-cases-graphs.html
#'
#' @examples
#' data(EbolaSierraLeone)
#'

NA

#' @title Electric Bill
#'
#' @description A data set containing the electric bill (in US dollars) of a single-family home in Minnesota from
#' 2000-2003
#'
#' @docType data
#' @name ElectricBill
#' @usage data(ElectricBill)
#' @details
#'   A data frame with 37 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (since January 2000)
#'     \item{\code{ElecBill}} (in US dollars)
#'   }
#'
#' @source
#' Subset of Utilities in the \code{mosaic} package.
#'
#' @examples
#' data(ElectricBill)
#'

NA

#' @title US Electronic and Mail Order Sales
#'
#' @description A data set containing the he total U.S. electronic and mail-order
#' shopping sales in billions of dollars each year from 1999 to 2012.
#'
#' @docType data
#' @name ElectronicMailOrderSales
#' @usage data(ElectronicMailOrderSales)
#' @details
#'   A data frame with 14 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Sales}} (in billions of US dollars)
#'   }
#'
#' @source
#' Total U.S. electronic and mail-order shopping sales in millions of
#' dollars each year from 1999 to 2012 from “Monthly & Annual Retail Trade,
#' Main Page — US Census Bureau.” Accessed on July 16, 2014.
#'
#' @examples
#' data(ElectronicMailOrderSales)
#'

NA

#' @title RPM of Different Engines
#'
#' @description A data set containing the revolutions per minute (RPM) and mass of different engines.
#'
#' @docType data
#' @name EngineRPM
#' @usage data(EngineRPM)
#' @details
#'   A data frame with 39 observations on the following variables.
#'   \itemize{
#'     \item{\code{Mass}} (in kilograms)
#'     \item{\code{RPM}}
#'   }
#'
#' @source
#' Revolutions per minute of engines as a function of engine mass from pages 60-61. McMahon,
#' Thomas A., and John Tyler Bonner. \emph{On Size and Life}. New York: Scientific American
#' Library, 1983.
#'
#' @examples
#' data(EngineRPM)
#'

NA

#' @title Facebook Users
#'
#' @description A data set containing the number of Facebook users in millions of people from 2009
#' through 2012.
#'
#' @docType data
#' @name FacebookUsers
#' @usage data(FacebookUsers)
#' @details
#'   A data frame with 38 observations on the following variables.
#'   \itemize{
#'     \item{\code{Months}} (since January 2009)
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of Facebook users in millions from 2009 through 2012 from “Number of active users at Facebook
#' over the years — Yahoo News” and “Facebook: number of active users 2015 | Statistics.”
#' Accessed on June 22, 2015.
#'
#' @references
#' http://news.yahoo.com/number-active-users-facebook-over-230449748.html
#' http://www.statista.com/statistics/264810/number-of-monthly-active-facebook-users-worldwide/
#'
#' @examples
#' data(FacebookUsers)
#'

NA

#' @title Ford Motors Market Volume
#'
#' @description A subset of the data set containing the volume of Ford Motor Company stock shares traded per
#' quarter since January 1, 2007.
#'
#' @docType data
#' @name FordMarketVolume1
#' @usage data(FordMarketVolume1)
#' @details
#'   A data frame with 7 observations on the following variables.
#'   \itemize{
#'     \item{\code{Date}} (quarter since January 1, 2007)
#'     \item{\code{Volume}} (number of shares of Ford Motor Company stock shares)
#'   }
#'
#' @source
#' Ford Motor Company (F) stock market value quarterly in U.S. dollars. Accessed on July 7, 2014
#'
#' @references
#' http://stooq.com/q/d/?s=f.us
#'
#' @examples
#' data(FordMarketVolume1)
#'

NA

#' @title Ford Motors Market Volume
#'
#' @description A data set containing the volume of Ford Motor Company stock shares traded per
#' quarter since January 1, 2007.
#'
#' @docType data
#' @name FordMarketVolume2
#' @usage data(FordMarketVolume2)
#' @details
#'   A data frame with 20 observations on the following variables.
#'   \itemize{
#'     \item{\code{Date}} (quarter since January 1, 2007)
#'     \item{\code{Volume}} (number of shares of Ford Motor Company stock shares)
#'   }
#'
#' @source
#' Ford Motor Company (F) stock market value quarterly in U.S. dollars. Accessed on July 7, 2014
#'
#' @references
#' http://stooq.com/q/d/?s=f.us
#'
#' @examples
#' data(FordMarketVolume1)
#'

NA

#' @title Gender Ratio in World Population
#'
#' @description A subset of the data set containing the number of males per 100 females in the word population.
#'
#' @docType data
#' @name GenderRatio1
#' @usage data(GenderRatio1)
#' @details
#'   A data frame with 9 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Ratio}} (number of males per 100 females)
#'   }
#'
#' @source
#' The global gender ratio based on the number of males per 100 females by year from
#' “World Population Prospects, the 2012 Revision” by the United Nations Department of
#' Economic and Social Affairs. Accessed on June 25, 2014.
#'
#' @references
#' http://esa.un.org/unpd/wpp/Excel-Data/population.htm
#'
#' @examples
#' data(GenderRatio1)
#'

NA

#' @title Gender Ratio in World Population
#'
#' @description A data set containing the number of males per 100 females in the word population.
#'
#' @docType data
#' @name GenderRatio2
#' @usage data(GenderRatio2)
#' @details
#'   A data frame with 14 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Ratio}} (number of males per 100 females)
#'   }
#'
#' @source
#' The global gender ratio based on the number of males per 100 females by year from
#' “World Population Prospects, the 2012 Revision” by the United Nations Department of
#' Economic and Social Affairs. Accessed on June 25, 2014.
#'
#' @references
#' http://esa.un.org/unpd/wpp/Excel-Data/population.htm
#'
#' @examples
#' data(GenderRatio2)
#'

NA

#' @title Tidal Depths in Pearl Harbor, Hawaii
#'
#' @description A data set containing the depth of the tide in feet relative to the MLLW (mean lower low water mark)
#' in Pearl Harbor, Hawaii as a function of time measured in hours Hr.
#'
#' @docType data
#' @name Hawaii
#' @usage data(Hawaii)
#' @details
#'   A data frame with 31 observations on the following variables.
#'   \itemize{
#'     \item{\code{time}} (in hours)
#'     \item{\code{water}} (tide depth in feet relative to the MLLW)
#'   }
#'
#' @source
#' Tidal measurements in Pearl Harbor, Hawaii based on data sets from Project Mosaic. Accessed on
#' August 19, 2015.
#'
#' @references
#' http://www.mosaic-web.org
#'
#' @examples
#' data(Hawaii)
#'

NA

#' @title Health Expenditures as a Percentage of U.S. GDP
#'
#' @description A data set containing the World Bank's data for total U.S. health expenditures as a percentage
#' of the U.S gross domestic product (GDP) from 1995 to 2012.
#'
#' @docType data
#' @name HealthExpenditure
#' @usage data(HealthExpenditure)
#' @details
#'   A data frame with 18 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{PercentGDP}}
#'   }
#'
#' @source
#' Total U.S. health expenditures as a percentage of GDP from the World Bank. Accessed on
#' July 10, 2014.
#' @references
#' http://data.worldbank.org/country/united-states
#'
#' @examples
#' data(HealthExpenditure)
#'

NA

#' @title Latino's Living in the United States
#'
#' @description A data set containing the number of Latino's living in the United States as a function of the year.
#'
#' @docType data
#' @name HispanicPopulation
#' @usage data(HispanicPopulation)
#' @details
#'   A data frame with 5 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{People}} (in millions)
#'   }
#'
#' @source
#' The U.S. Hispanic population has increased sixfold since 1970. Accessed on June 16, 2014.
#'
#' @references
#' http://www.pewresearch.org/fact-tank/2014/02/26/the-u-s-hispanic-population-has-increased-sixfold-since-1970/
#'
#' @examples
#' data(HispanicPopulation)
#'

NA

#' @title High School Dropout Rate
#'
#' @description A data set containing the high school dropout rate in the United States from 1970 through 2012.
#'
#' @docType data
#' @name HSDropoutRate
#' @usage data(HSDropoutRate)
#' @details
#'   A data frame with 43 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Rate}} (high school dropout rate)
#'   }
#'
#' @source
#' The high school dropout rate in the United States from 1970 through 2012 from “Percentage of high school
#' dropouts among persons 16 to 24 years old.” Accessed on June 22, 2015.
#'
#' @references
#' http://nces.ed.gov/programs/digest/d13/tables/dt13 219.70.asp
#'
#' @examples
#' data(HSDropoutRate)
#'

NA

#' @title High School Graduates in College
#'
#' @description A data set containing the percent of each year’s high school
#' graduates to enroll in either a two-year or four-year college from 1972 to 2012.
#'
#' @docType data
#' @name HSGradsInCollege
#' @usage data(HSGradsInCollege)
#' @details
#'   A data frame with 41 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Percent}} (of high schol graduates)
#'   }
#'
#' @source
#' Percent of high school graduates to enroll in a two-year or four-year college from National Center
#' for Education Statistics. Accessed on July 2, 2014.
#'
#' @references
#' http://nces.ed.gov/programs/digest/d13/tables/dt13302.10.asp
#'
#' @examples
#' data(HSGradsInCollege)
#'

NA

#' @title Life Expectancy in Different Countries
#'
#' @description A data set containing the number of physicians per 1000 people as a function of average
#' life expectancy in different countries in 2010.
#'
#' @docType data
#' @name LifeExpectancyPhysicians
#' @usage data(LifeExpectancyPhysicians)
#' @details
#'   A data frame with 175 observations on the following variables.
#'   \itemize{
#'     \item{\code{LifeExpectancy}} (life expectancy in years)
#'     \item{\code{Physicians}} (number of physicians per 1000 people)
#'   }
#'
#' @source
#' Number of physicians per 1000 people as a function of average life expectancy in different
#' countries in 2010 from “Physicians (per 1,000 people) | Data | Table.”
#'
#' @references
#' http://data.worldbank.org/indicator/SH.MED.PHYS.ZS
#'
#' @examples
#' data(LifeExpectancyPhysicians)
#'

NA

#' @title Atmospheric Carbon Dioxide from Mauna Loa
#'
#' @description A data set containing the atmospheric carbon dioxide from Mauna Loa in ppmv (or parts per million
#' by volume) as a function of years from 1958 to 2008.
#'
#' @docType data
#' @name MaunaLoaCO2
#' @usage data(MaunaLoaCO2)
#' @details
#'   A data frame with 49 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Average}} (in ppmv)
#'   }
#'
#' @source
#' Atmospheric carbon dioxide from Mauna Loa in ppmv (parts per million by volume) as a function of
#' years from 1958 to 2008 from “Atmospheric Carbon Dioxide Record from Mauna Loa.” Accessed on
#' August 19, 2015.
#'
#' @references
#' http://cdiac.ornl.gov/trends/co2/sio-mlo.html
#'
#' @examples
#' data(MaunaLoaCO2)
#'

NA

#' @title Burgers Sold by McDonalds
#'
#' @description A subset of the data set containing the number of burgers (in billions) sold by McDonald’s since 1955.
#'
#' @docType data
#' @name McDBurgers1
#' @usage data(McDBurgers1)
#' @details
#'   A data frame with 5 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Burgers}} (in billions)
#'   }
#'
#' @source
#' The total number of burgers sold by McDonald’s in billions as of each year from “Over How
#' Many Billion Served.” Accessed on July 3, 2014.
#'
#' @references
#' http://overhowmanybillionserved.blogspot.com/
#'
#' @examples
#' data(McDBurgers1)
#'

NA

#' @title Burgers Sold by McDonalds
#'
#' @description A data set containing the number of burgers (in billions) sold by McDonald’s since 1955.
#'
#' @docType data
#' @name McDBurgers2
#' @usage data(McDBurgers2)
#' @details
#'   A data frame with 11 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Burgers}} (in billions)
#'   }
#'
#' @source
#' The total number of burgers sold by McDonald’s in billions as of each year from “Over How
#' Many Billion Served.” Accessed on July 3, 2014.
#'
#' @references
#' http://overhowmanybillionserved.blogspot.com/
#'
#' @examples
#' data(McDBurgers2)
#'

NA

#' @title US Unemployment Rate
#'
#' @description A data set containing the United States monthly unemployment rate from January 2010 to December 2014.
#'
#' @docType data
#' @name MonthlyUnemployment
#' @usage data(MonthlyUnemployment)
#' @details
#'   A data frame with 60 observations on the following variables.
#'   \itemize{
#'     \item{\code{Months}} (since January 2010)
#'     \item{\code{Rate}} (monthly unemployment rate)
#'   }
#'
#' @source
#' U.S. monthly unemployment rate from January 2010 to December 2014 from “Bureau of Labor Statistics Data.”
#' Accessed on June 22, 2015.
#'
#' @references
#' http://data.bls.gov/timeseries/LNS14000000
#'
#' @examples
#' data(MonthlyUnemployment)
#'

NA

#' @title 15 Year Annual Mortgage Rates
#'
#' @description A data set containing interest rates on 15-year, fixed-rate conventional home mortgages annually from
#' 1992 to 2014.
#'
#' @docType data
#' @name Mortgage15YrAnnual
#' @usage data(Mortgage15YrAnnual)
#' @details
#'   A data frame with 23 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Rate}} (interest rate on 15-year, fixed-rate conventional home mortgage)
#'   }
#'
#' @source
#' Interest rates on 15-year, fixed-rate conventional home mortgages annually from 1992 to 2014 from
#' “Mortgage Interest Rates History.” Accessed on June 22, 2015.
#'
#' @references
#' http://www.fedprimerate.com/mortgagerates.htm
#'
#' @examples
#' data(Mortgage15YrAnnual)
#'

NA

#' @title 30 Year Annual Mortgage Rates
#'
#' @description A data set containing the average interest rate for conventional 30-year mortgages each year
#' from 1981 to 2012.
#'
#' @docType data
#' @name Mortgage30YrAnnual
#' @usage data(Mortgage30YrAnnual)
#' @details
#'   A data frame with 32 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Rate}} (average interest rate on conventional 30-year mortgage)
#'   }
#'
#' @source
#' Average interest rate for conventional 30-year mortgages each year from 1981 to 2012 from
#' “Primary Mortgage Market Survey Archives — 30 Year Fixed Rate Mortgages — Freddie Mac.”
#' Accessed on July 7, 2015.
#'
#' @references
#' http://www.freddiemac.com/pmms/pmms30.htm
#'
#' @examples
#' data(Mortgage30YrAnnual)
#'

NA

#' @title 30 Year Annual Mortgage Rates
#'
#' @description A subset of the data set containing the interest rate on a 30-year fixed-rate conventional home mortgage.
#'
#' @docType data
#' @name Mortgage30YrMonthly1
#' @usage data(Mortgage30YrMonthly1)
#' @details
#'   A data frame with 265 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}}
#'     \item{\code{Rate}} (average interest rate on conventional 30-year mortgage)
#'   }
#'
#' @source
#' Average interest rate for conventional 30-year mortgages each year from 1981 to 2012 from
#' “Primary Mortgage Market Survey Archives — 30 Year Fixed Rate Mortgages — Freddie Mac.”
#' Accessed on July 7, 2015.
#'
#' @references
#' http://www.freddiemac.com/pmms/pmms30.htm
#'
#' @examples
#' data(Mortgage30YrMonthly1)
#'

NA

#' @title 30 Year Annual Mortgage Rates
#'
#' @description A data set containing the interest rate on a 30-year fixed-rate conventional home mortgage.
#'
#' @docType data
#' @name Mortgage30YrMonthly2
#' @usage data(Mortgage30YrMonthly2)
#' @details
#'   A data frame with 519 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}}
#'     \item{\code{Rate}} (average interest rate on conventional 30-year mortgage)
#'   }
#'
#' @source
#' Average interest rate for conventional 30-year mortgages each year from 1981 to 2012 from
#' “Primary Mortgage Market Survey Archives — 30 Year Fixed Rate Mortgages — Freddie Mac.”
#' Accessed on July 7, 2015.
#'
#' @references
#' http://www.freddiemac.com/pmms/pmms30.htm
#'
#' @examples
#' data(Mortgage30YrMonthly2)
#'

NA

#' @title Closing NASDAQ Value
#'
#' @description A data set containing the closing NASDAQ stock market value in U.S. dollars at the end of each
#' quarter from March 1938 (quarter 1) through December 2014 (quarter 308)
#'
#' @docType data
#' @name NASDAQQuarterly
#' @usage data(NASDAQQuarterly)
#' @details
#'   A data frame with 308 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since March 1938)
#'     \item{\code{Close}}
#'   }
#'
#' @source
#' Closing stock market value of the Dow Jones Industrial Average at the end of each quarter
#' from March 31, 1930 through December 31, 2014 from “^DJI — Nasdaq Composite — U.S. — Stooq.”
#' Accessed on July 7, 2015.
#'
#' @references
#' http://stooq.com/q/d/?s=^dji
#'
#' @examples
#' data(NASDAQQuarterly)
#'

NA

#' @title US Natural Gas Consumption
#'
#' @description A subset of the data set containing the total number of millions of cubic feet of natural gas consumed
#' in the United States from 1950 to 1970.
#'
#' @docType data
#' @name NaturalGasConsumption
#' @usage data(NaturalGasConsumption)
#' @details
#'   A data frame with 21 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{CubicFeet}} (in millions of cubic feet)
#'   }
#'
#' @source
#' Natural Gas from U.S. Energy Information Administration. Accessed on June 9, 2016.
#'
#' @references
#' http://www.eia.gov/dnav/ng/hist/n9140us2a.htm
#'
#' @examples
#' data(NaturalGasConsumption)
#'

NA

#' @title US Natural Gas Consumption
#'
#' @description A data set containing the total number of millions of cubic feet of natural gas consumed
#' in the United States from 1950 to 1970.
#'
#' @docType data
#' @name NaturalGasConsumption2
#' @usage data(NaturalGasConsumption2)
#' @details
#'   A data frame with 67 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{CubicFeet}} (in millions of cubic feet)
#'   }
#'
#' @source
#' Natural Gas from U.S. Energy Information Administration. Accessed on June 9, 2016.
#'
#' @references
#' http://www.eia.gov/dnav/ng/hist/n9140us2a.htm
#'
#' @examples
#' data(NaturalGasConsumption2)
#'

NA

#' @title Population of the Netherlands
#'
#' @description A data set containing the population of the Netherlands measured in millions of people
#' at the beginning of each decade since 1700.
#'
#' @docType data
#' @name NetherlandsPopulation
#' @usage data(NetherlandsPopulation)
#' @details
#'   A data frame with 21 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Population}} (in millions of people)
#'   }
#'
#' @source
#' Population of the Netherlands from “The NETHERLANDS : country populations.”
#' Accessed on July 11, 2014.
#'
#' @references
#' http://www.populstat.info/Europe/netherlc.htm
#'
#' @examples
#' data(NetherlandsPopulation)
#'

NA

#' @title Annual US Oil Production
#'
#' @description A subset of the data set containing the number of barrels (in thousands) of crude oil produced per year
#' in the United States.
#'
#' @docType data
#' @name OilProductionAnnual1
#' @usage data(OilProductionAnnual1)
#' @details
#'   A data frame with 38 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Barrels}} (in thousands)
#'   }
#'
#' @source
#' U.S. field production of crude oil in billions of barrels from the U.S. Energy Information
#' Administration from “U.S. Field Production of Crude Oil.” Accessed on July 3, 2014.
#'
#' @references
#' http://www.eia.gov/dnav/pet/hist/LeafHandler.ashx?n=PET&s=MCRFPUS1&f=M
#'
#' @examples
#' data(OilProductionAnnual1)
#'

NA

#' @title Annual US Oil Production
#'
#' @description A subset of the data set containing the number of barrels (in thousands) of crude oil produced per year
#' in the United States.
#'
#' @docType data
#' @name OilProductionAnnual2
#' @usage data(OilProductionAnnual2)
#' @details
#'   A data frame with 114 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Barrels}} (in thousands)
#'   }
#'
#' @source
#' U.S. field production of crude oil in billions of barrels from the U.S. Energy Information
#' Administration from “U.S. Field Production of Crude Oil.” Accessed on July 3, 2014.
#'
#' @references
#' http://www.eia.gov/dnav/pet/hist/LeafHandler.ashx?n=PET&s=MCRFPUS1&f=M
#'
#' @examples
#' data(OilProductionAnnual2)
#'

NA

#' @title Pollen Count in Los Angeles, CA
#'
#' @description A data set containing the pollen count each day in Los Angeles from April to July of 2014.
#'
#' @docType data
#' @name PollenCountLA
#' @usage data(PollenCountLA)
#' @details
#'   A data frame with 30 observations on the following variables.
#'   \itemize{
#'     \item{\code{Date}} (since April 1, 2014)
#'     \item{\code{Count}} (Pollen count in Los Angeles, CA)
#'   }
#'
#' @source
#' Three-year average monthly pollen count in Los Angeles, California from “Historic Allergy Index
#' for 90001 | Pollen.com.” Accessed on June 25, 2014.
#'
#' @references
#' http://www.pollen.com/allergy-trends.asp?PostalCode=90001
#'
#' @examples
#' data(PollenCountLA)
#'

NA

#' @title Population of Belgium
#'
#' @description A data set containing the population of Belgium in millions of people.
#'
#' @docType data
#' @name PopulationBelgium
#' @usage data(PopulationBelgium)
#' @details
#'   A data frame with 18 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{People}} (in millions of people)
#'   }
#'
#' @source
#' Population of Belgium in millions of people by year from “Population of the Netherlands,
#' Belgium, and Luxembourg.” Accessed on June 26, 2014.
#'
#' @references
#' http://www.tacitus.nu/historical-atlas/population/benelux.htm
#'
#' @examples
#' data(PopulationBelgium)
#'

NA

#' @title Running Speed of Animals
#'
#' @description A data set containing the running speed in centimeters per second as a function of the
#' length in centimeters of various animals.
#'
#' @docType data
#' @name RunningSpeed
#' @usage data(RunningSpeed)
#' @details
#'   A data frame with 12 observations on the following variables.
#'   \itemize{
#'     \item{\code{Length}} (in centimeters)
#'     \item{\code{Speed}} (in centimeters per second)
#'   }
#'
#' @source
#' Running speed and length of animals from page 152. McMahon, Thomas A., and John Tyler Bonner.
#' \emph{On Size and Life}. New York: Scientific American Library, 1983.
#'
#' @examples
#' data(RunningSpeed)
#'

NA

#' @title SAT Math Scores in Kentucky
#'
#' @description A data set containing the average SAT math score in Kentucky each year from 1980 to 2013.
#'
#' @docType data
#' @name SATMathKentucky
#' @usage data(SATMathKentucky)
#' @details
#'   A data frame with 34 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Score}} (Average SAT math score in Kentucky)
#'   }
#'
#' @source
#' Average SAT math score in Kentucky each year from 1980 to 2013 from College Board’s 2013 SAT
#' State Profile Report for Kentucky. Accessed on July 16, 2014.
#'
#' @references
#' http://media.collegeboard.com/digitalServices/pdf/research/2013/KY_13_03_03_01.pdf
#'
#' @examples
#' data(SATMathKentucky)
#'

NA

#' @title Average Student Debt
#'
#' @description A subset of the data set containing the average cumulative debt of bachelor’s degree students enrolled in
#' public colleges and universities.
#'
#' @docType data
#' @name StudentDebt1
#' @usage data(StudentDebt1)
#' @details
#'   A data frame with 7 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Debt}} (Average cummulative debt)
#'   }
#'
#' @source
#' Average debt load in 2013 dollars of bachelor’s degree recipients attending U.S. public
#' colleges and universities who borrowed money to finance their education from “Average Cumulative
#' Debt Load of Bachelor’s Degree Recipients at Public Four-Year Institutions over Time — Trends
#' in Higher Education.” Accessed on July 5, 2015.
#'
#' @references
#' https://trends.collegeboard.org/student-aid/figures-tables/average-debt-levels-public-sector-bachelors-degree-recipients-over-time
#'
#' @examples
#' data(StudentDebt1)
#'

NA

#' @title Average Student Debt
#'
#' @description A data set containing the average cumulative debt of bachelor’s degree students enrolled in
#' public colleges and universities.
#'
#' @docType data
#' @name StudentDebt2
#' @usage data(StudentDebt2)
#' @details
#'   A data frame with 15 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Debt}} (Average cumulative debt)
#'   }
#'
#' @source
#' Average debt load in 2013 dollars of bachelor’s degree recipients attending U.S. public
#' colleges and universities who borrowed money to finance their education from “Average Cumulative
#' Debt Load of Bachelor’s Degree Recipients at Public Four-Year Institutions over Time — Trends
#' in Higher Education.” Accessed on July 5, 2015.
#'
#' @references
#' https://trends.collegeboard.org/student-aid/figures-tables/average-debt-levels-public-sector-bachelors-degree-recipients-over-time
#'
#' @examples
#' data(StudentDebt2)
#'

NA

#' @title Sun Position in Anchorage, Alaska
#'
#' @description A data set containing the altitude angle of the sun in Anchorage, Alaska, each hour from
#' midnight on June 29, 2014 (hour 0) until midnight on June 30, 2014 (hour 24).
#'
#' @docType data
#' @name SunPositionAlaska
#' @usage data(SunPositionAlaska)
#' @details
#'   A data frame with 25 observations on the following variables.
#'   \itemize{
#'     \item{\code{Time}} (hours since midnight on June 29, 2014)
#'     \item{\code{Position}} (Altitude angle of the sun)
#'   }
#'
#' @source
#' Altitude angle of the sun in Anchorage, Alaska, each hour from midnight on June 29, 2014
#' (hour 0) until midnight on June 30, 2014 (hour 24) from “Sun & moon times, Anchorage, Alaska,
#' U.S.A.” Accessed on July 1, 2014.
#'
#' @references
#' http://www.timeanddate.com/astronomy/usa/anchorage
#'
#' @examples
#' data(SunPositionAlaska)
#'

NA

#' @title Sunrise in Los Angeles, CA
#'
#' @description A data set containing the number of minutes after 4 a.m. until sunrise in Los Angeles,
#' California, adjusted for Daylight Savings Time, from January 2010 (month 1) through
#' December 2011 (month 24).
#'
#' @docType data
#' @name SunriseLA
#' @usage data(SunriseLA)
#' @details
#'   A data frame with 24 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (from January 2010)
#'     \item{\code{Time}} (minutes after 4 a.m.)
#'   }
#'
#' @source
#' Number of minutes after 4 a.m. until sunrise in Los Angeles, adjusted for Daylight Savings Time,
#' from January 2010 (month 1) through December 2011 (month 24) from “Sunrise and sunset times in
#' Los Angeles, December 2011.” Accessed on July 14, 2014.
#'
#' @references
#' http://www.timeanddate.com/sun/usa/los-angeles?month=12&year=2011
#'
#' @examples
#' data(SunriseLA)
#'

NA

#' @title Sunset in Greenwich, England
#'
#' @description A data set containing the number of minutes after 3 p.m. until sunset at Greenwich, England
#' since January 2010.
#'
#' @docType data
#' @name SunsetGreenwich
#' @usage data(SunsetGreenwich)
#' @details
#'   A data frame with 25 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (from January 2010)
#'     \item{\code{Minutes}} (minutes after 3 p.m.)
#'   }
#'
#' @source
#' Number of minutes after 3 p.m. until sunset in Greenwich, England since January 2010 from
#' “Sunrise and sunset times in Greenwich Borough.” Accessed on July 14, 2014.
#'
#' @references
#' http://www.timeanddate.com/sun/uk/greenwich-city
#'
#' @examples
#' data(SunsetGreenwich)
#'

NA

#' @title Sunset in Los Angeles, CA
#'
#' @description A data set containing the number of minutes after 4 p.m. until sunset in Los Angeles,
#' California, adjusted for Daylight Savings time, from January 2010 (month 1) through
#' December 2013 (month 48).
#'
#' @docType data
#' @name SunsetLA
#' @usage data(SunsetLA)
#' @details
#'   A data frame with 48 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (from January 2010)
#'     \item{\code{Minutes}} (minutes after 4 p.m.)
#'   }
#'
#' @source
#' Number of minutes after 4 p.m. until sunset in Los Angeles, California, adjusted for
#' Daylight Savings Time, from January 2010 (month 1) through December 2013 (month 48)
#' from “Sunrise and sunset times in Los Angeles, December 2011.” Accessed on July 14, 2014.
#'
#' @references
#' http://www.timeanddate.com/sun/usa/los-angeles?month=12&year=2011
#'
#' @examples
#' data(SunsetLA)
#'

NA

#' @title Swimming Speed of Various Animals
#'
#' @description A data set containing the swimming speed in centimeters per second as a function of the length
#' in centimeters of various animals
#'
#' @docType data
#' @name SwimmingSpeed
#' @usage data(SwimmingSpeed)
#' @details
#'   A data frame with 17 observations on the following variables.
#'   \itemize{
#'     \item{\code{Length}} (in centimeters)
#'     \item{\code{Speed}} (swimming speed of animal in centimeters per second)
#'   }
#'
#' @source
#' Swimming speed and length of animals from page 152. McMahon, Thomas A., and John Tyler Bonner.
#' \emph{On Size and Life}. New York: Scientific American Library, 1983.
#'
#' @examples
#' data(SwimmingSpeed)
#'

NA

#' @title Temperatures in Danville, KY
#'
#' @description A data set containing the average maximum temperature in Danville, Kentucky at the beginning
#' of each month since January 2006
#'
#' @docType data
#' @name TemperaturesDanville
#' @usage data(TemperaturesDanville)
#' @details
#'   A data frame with 60 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (from January 2006)
#'     \item{\code{Temperature}} (in degrees Fahrenheit)
#'   }
#'
#' @source
#' Average maximum temperature in Danville, Kentucky at the beginning of each month since January
#' 2006 from “noaa.gov.” Accessed on June 25, 2014
#'
#' @references
#' http://www1.ncdc.noaa.gov/pub/orders/cdo/352625.pdf
#'
#' @examples
#' data(TemperaturesDanville)
#'

NA

#' @title Toyota Stock Prices
#'
#' @description A data set containing the average monthly stock price of Toyota from 1982 to 1998.
#'
#' @docType data
#' @name ToyotaMonthly
#' @usage data(ToyotaMonthly)
#' @details
#'   A data frame with 60 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (from January 1982)
#'     \item{\code{Value}} (in US dollars)
#'   }
#'
#' @source
#' Toyota Motors Corporation (TM) stock market value in U.S. dollars from “Yahoo Finance |
#' TM Historical Prices.” Accessed on August 13, 2016.
#'
#' @references
#' http://finance.yahoo.com/quote/TM/history?p=TM
#'
#' @examples
#' data(ToyotaMonthly)
#'

NA

#' @title Twitter Users
#'
#' @description A data set containing the number of monthly active Twitter users worldwide by quarter
#' (e.g., 10.25 represents April to June 2010) in millions of people.
#'
#' @docType data
#' @name TwitterUsers
#' @usage data(TwitterUsers)
#' @details
#'   A data frame with 17 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}} (since 2000)
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of monthly active Twitter users worldwide from 1st quarter 2010
#' to 1st quarter 2016 (in millions) from “Twitter : number of monthly active users 2010–2016 |
#' Statista.” Accessed on June 9, 2016.
#'
#' @references
#' http://www.statista.com/statistics/282087/number-of-monthly-active-twitter-users/
#'
#' @examples
#' data(TwitterUsers)
#'

NA

#' @title Twitter Users
#'
#' @description A data set containing how many millions of people used Twitter from the
#' first quarter of 2012 to the end of the third quarter of 2013.
#'
#' @docType data
#' @name TwitterUsers1
#' @usage data(TwitterUsers1)
#' @details
#'   A data frame with 8 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}} (since 2000)
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of monthly active Twitter users worldwide from 1st quarter 2010
#' to 1st quarter 2016 (in millions) from “Twitter : number of monthly active users 2010–2016 |
#' Statista.” Accessed on June 9, 2016.
#'
#' @references
#' http://www.statista.com/statistics/282087/number-of-monthly-active-twitter-users/
#'
#' @examples
#' data(TwitterUsers1)
#'

NA

#' @title Twitter Users
#'
#' @description A data set containing how many millions of people used Twitter from the first quarter
#' of 2010 to the end of the third quarter of 2013.
#'
#' @docType data
#' @name TwitterUsers2
#' @usage data(TwitterUsers2)
#' @details
#'   A data frame with 15 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}} (since 2000)
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of monthly active Twitter users worldwide from 1st quarter 2010
#' to 1st quarter 2016 (in millions) from “Twitter : number of monthly active users 2010–2016 |
#' Statista.” Accessed on June 9, 2016.
#'
#' @references
#' http://www.statista.com/statistics/282087/number-of-monthly-active-twitter-users/
#'
#' @examples
#' data(TwitterUsers2)
#'

NA

#' @title Twitter Users
#'
#' @description A data set containing how many millions of people used Twitter from the first quarter of 2010
#' to the beginning of 2016.
#'
#' @docType data
#' @name TwitterUsers3
#' @usage data(TwitterUsers3)
#' @details
#'   A data frame with 24 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}} (since 2000)
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of monthly active Twitter users worldwide from 1st quarter 2010
#' to 1st quarter 2016 (in millions) from “Twitter : number of monthly active users 2010–2016 |
#' Statista.” Accessed on June 9, 2016.
#'
#' @references
#' http://www.statista.com/statistics/282087/number-of-monthly-active-twitter-users/
#'
#' @examples
#' data(TwitterUsers3)
#'

NA

#' @title US CO2 Emissions
#'
#' @description A data set containing U.S. carbon dioxide emissions in kT (energy) annually from 1980 to 2008
#' according to the World Bank.
#'
#' @docType data
#' @name USCO2Emissions
#' @usage data(USCO2Emissions)
#' @details
#'   A data frame with 29 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{kT}}
#'   }
#'
#' @source
#' United States carbon dioxide emissions in kT annually from 1960 to 2010 according to the
#' World Bank at “Data | United States.” Accessed on July 10, 2014.
#'
#' @references
#' http://data.worldbank.org/country/united-states
#'
#' @examples
#' data(USCO2Emissions)
#'

NA

#' @title US Retail Tax
#'
#' @description A data set containing U.S. retail tax in millions of dollars each year from 2005 through 2011.
#'
#' @docType data
#' @name USRetailTax
#' @usage data(USRetailTax)
#' @details
#'   A data frame with 7 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Tax}} (in millions of dollars)
#'   }
#'
#' @source
#' Annual total retail sales taxes collected in the United States in each year from
#' “Monthly & Annual Retail Trade, Main Page — U.S. Census Bureau.” Accessed on July 14, 2014.
#'
#' @references
#' http://www.census.gov/retail/
#'
#' @examples
#' data(USRetailTax)
#'

NA

#' @title Total U.S. Population
#'
#' @description A data set containing the U.S. population in millions of people each decade from 1900 to 2010
#' based on the census.
#'
#' @docType data
#' @name USTotalPopulation
#' @usage data(USTotalPopulation)
#' @details
#'   A data frame with 9 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}} {}
#'     \item{\code{Population}} (US population in millions of people)
#'     \item{\code{RelGrowth}} (Relative growth rate of the US population)
#'   }
#'
#' @source
#' U.S. census data for 1950–2000 is from “Measuring America: The Decennial Censuses from 1790 to
#' 2000.” Accessed on June 9, 2016.
#'
#' @references
#' https://www.census.gov/prod/2002pubs/pol02-ma.pdf
#' http://www.census.gov/2010census/popmap/
#'
#'
#' @examples
#' data(USTotalPopulation)
#'

NA

#' @title Water Levels in Eastport, Maine
#'
#' @description A data set containing the water level in Eastport, Maine from May 26, 2016 to May 27, 2016
#' measured in feet above the mean lower water level as a function of the time after 12:00 a.m. on
#' May 26, 2016.
#'
#' @docType data
#' @name WaterLevelsEastportMaine
#' @usage data(WaterLevelsEastportMaine)
#' @details
#'   A data frame with 477 observations on the following variables.
#'   \itemize{
#'     \item{\code{Hours}} (since 12 a.m. on May 26m, 2016)
#'     \item{\code{WaterLevel}} (feet above the mean lower water level)
#'   }
#'
#' @source
#' Observed water levels in Eastport, Maine from NOAA Tides and Currents. Accessed on June 2, 2016.
#'
#' @references
#' http://tidesandcurrents.noaa.gov/waterlevels.html?id=8410140&units=standard&bdate=20160526&edate=20160527&timezone=GMT&datum=MLLW&interval=6&action=
#'
#'
#' @examples
#' data(WaterLevelsEastportMaine)
#'

NA

#' @title Weight Change during Pregnancy
#'
#' @description A data set containing the change in one woman’s weight during a pregnancy from the beginning of
#' her second trimester until birth.
#'
#' @docType data
#' @name WeightChange
#' @usage data(WeightChange)
#' @details
#'   A data frame with 129 observations on the following variables.
#'   \itemize{
#'     \item{\code{Day}} (since beginning of second trimester)
#'     \item{\code{Weight}} (in pounds)
#'   }
#'
#' @source
#' Personal data collection
#'
#' @examples
#' data(WeightChange)
#'

NA

#' @title World Population
#'
#' @description A data set containing the total midyear population for the world from 1950 to 2015.
#'
#' @docType data
#' @name WorldPopulation
#' @usage data(WorldPopulation)
#' @details
#'   A data frame with 14 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{People}} (in billions)
#'   }
#'
#' @source
#' Estimated world population data from 1950 to 2015 from “International Programs — Total
#' Mid-Year Population for the World: 1950–2050 — U.S. Census Bureau.” Accessed on June 16, 2014.
#'
#' @references
#' http://www.census.gov/population/international/data/worldpop/table_population.php
#'
#' @examples
#' data(WorldPopulation)
#'

NA

#' @title World Population Change
#'
#' @description A data set containing the percent growth of the world’s population as a function of the year
#'from 1970 to 2015.
#'
#' @docType data
#' @name WorldPopulationChange
#' @usage data(WorldPopulationChange)
#' @details
#'   A data frame with 10 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Growth}} (Percent growth of worlds population)
#'   }
#'
#' @source
#' World population from the U.S. Census Bureau. Accessed on June 3, 2016.
#'
#' @references
#' http://www.census.gov/population/international/data/worldpop/table_population.php
#'
#' @examples
#' data(WorldPopulationChange)
#'

NA

#' @title Yellow Cards in World Cup
#'
#' @description A data set containing the number of yellow cards given per men’s World Cup tournament from
#' 1970 to 2010.
#'
#' @docType data
#' @name YellowCards
#' @usage data(YellowCards)
#' @details
#'   A data frame with 11 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Cards}} Number of yellow cards given
#'   }
#'
#' @source
#' Number of yellow cards given per men’s World Cup tournament from “Planet World Cup.”
#' Accessed on July 16, 2014.
#'
#' @references
#' http://www.planetworldcup.com
#'
#' @examples
#' data(YellowCards)
#'

NA

#' @title Average Global Sea Surface Temperature
#'
#' @description A data set containing the average sea surface temperature from 1910 to 2020,
#' measured in degrees Fahrenheit from a 1971-2000 baseline average.
#'
#' @docType data
#' @name SeaTemperature
#' @usage data(SeaTemperature)
#' @details
#'   A data frame with 111 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Temperature}} (in degrees Fahrenheit)
#'   }
#'
#' @source
#' Average global sea surface temperature from ``Climate Change Indicators: Sea
#' Surface Temperature.'' Accessed on April 25, 2024.
#'
#' @references
#' https://www.epa.gov/climate-indicators/climate-change-indicators-sea-surface-temperature
#'
#' @examples
#' data(SeaTemperature)
#'

NA

#' @title Urban Population
#'
#' @description A data set containing the urban population of the United States (in millions)
#' from 1960 to 2020.
#'
#' @docType data
#' @name UrbanPopulation
#' @usage data(UrbanPopulation)
#' @details
#'   A data frame with 61 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Population}} (in millions of people)
#'   }
#'
#' @source
#' Size of the urban and rural population of the United States from 1960 to
#' 2020 (in millions). Accessed on September 19, 2024.
#'
#' @references
#' https://www.statista.com/statistics/985183/size-urban-rural-population-us/
#'
#' @examples
#' data(UrbanPopulation)
#'
NA

#' @title Global CO2 Emissions
#'
#' @description A data set containing the annual worldwide carbon dioxide emissions in billion
#' metric tons from 1940 to 2023.
#'
#' @docType data
#' @name GlobalCO2Emissions
#' @usage data(GlobalCO2Emissions)
#' @details
#'   A data frame with 84 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Emissions}} (in billion metric tons)
#'   }
#'
#' @source
#' Annual carbon dioxide emissions worldwide from 1940 to 2023 (in billion
#' metric tons). Accessed on September 26, 2024.
#'
#' @references
#' https://www.statista.com/statistics/276629/global-co2-emissions/
#'
#' @examples
#' data(GlobalCO2Emissions)
#'
NA

#' @title Dunkin' Donuts Stores Worldwide
#'
#' @description A data set containing the number of Dunkin' Donuts stores worldwide from
#' 2007 to 2019.
#'
#' @docType data
#' @name DunkinDonuts
#' @usage data(DunkinDonuts)
#' @details
#'   A data frame with 13 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Stores}}
#'   }
#'
#' @source
#' Number of Dunkin' Donuts stores worldwide from 2007 to 2019, by region.
#' Accessed on September 19, 2024.
#'
#' @references
#' https://www.statista.com/statistics/291462/distribution-points-dunkin-donuts/
#'
#' @examples
#' data(DunkinDonuts)
#'

NA

#' @title Organic Food Sales
#'
#' @description A data set containing the organic food sales in the United States in billions
#' of U.S. dollars from 2005 to 2023.
#'
#' @docType data
#' @name OrganicFood
#' @usage data(OrganicFood)
#' @details
#'   A data frame with 19 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Sales}} (billions of US dollars)
#'   }
#'
#' @source
#' Organic food sales in the United States from 2005 to 2023 (in billion U.S.
#' dollars). Accessed on September 26, 2024.
#'
#' @references
#' https://www.statista.com/statistics/196952/organic-food-sales-in-the-us-since-2000/
#'
#' @examples
#' data(OrganicFood)
#'
NA

#' @title United States Vehicle Registrations
#'
#' @description A data set containing the number of motor vehicles registered in the United
#' States in 1000's from 1990 to 2022.
#'
#' @docType data
#' @name VehicleRegistrations
#' @usage data(VehicleRegistrations)
#' @details
#'   A data frame with 33 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Vehicles}} (in 1000's)
#'   }
#'
#' @source
#' Number of motor vehicles registered in the United States from 1990 to 2022
#' (in 1,000s). Accessed on September 26, 2024.
#'
#' @references
#' https://www.statista.com/statistics/183505/number-of-vehicles-in-the-united-states-since-1990/
#'
#' @examples
#' data(VehicleRegistrations)
#'
NA

#' @title Pesticide Consumption
#'
#' @description A data set containing the worldwide agricultural consumption of pesticides
#' in million metric tons from 1990 to 2022.
#'
#' @docType data
#' @name PesticideConsumption
#' @usage data(PesticideConsumption)
#' @details
#'   A data frame with 33 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Pesticide}} (in million metric tons)
#'   }
#'
#' @source
#' Agricultural consumption of pesticides worldwide from 1990 to 2022
#' (in million metric tons). Accessed on September 26, 2024.
#'
#' @references
#' https://www.statista.com/statistics/1263077/global-pesticide-agricultural-use/
#'
#' @examples
#' data(PesticideConsumption)
#'
NA

#' @title CHIP Consumption Expenditures
#'
#' @description A data set containing the Children's Health Insurance Program (CHIP)
#' consumption expenditures from 2005 to 2022 in millions of US dollars.
#'
#' @docType data
#' @name CHIPExpenditures
#' @usage data(CHIPExpenditures)
#' @details
#'   A data frame with 18 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Expenditure}} (in millions of US dollars)
#'   }
#'
#' @source
#' Children's health insurance program (CHIP) health consumption expenditure
#' from 2000-2022 (in million U.S. dollars). Accessed on March 11, 2025.
#'
#' @references
#' https://www.statista.com/statistics/245384/chip-personal-health-care-expenditure/
#'
#' @examples
#' data(CHIPExpenditures)
#'
NA

#' @title Closing NASDAQ Market Value
#'
#' @description A data set containing the closing NASDAQ stock market value in U.S. dollars at
#' the end of each quarter from March 1938 (Quarter=1) through September 2024
#' (Quarter=347).
#'
#' @docType data
#' @name NASDAQ
#' @usage data(NASDAQ)
#' @details
#'   A data frame with 347 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}}
#'     \item{\code{Close}}
#'   }
#'
#' @source
#' Closing NASDAQ stock market value in U.S. dollars at the end of each quarter
#' from March 1938 through September 2024 from ``Stooq:Historical data: Nasdaq
#' Composite - U.S. '' Accessed on September 27, 2024.
#'
#' @references
#' https://stooq.com/q/d/?s=\%5Endq&c=0&i=q
#'
#' @examples
#' data(NASDAQ)
#'
NA

#' @title Transistors in an Integrated Circuit
#'
#' @description A data set containing the number of transistors in an integrated circuit from
#' 1971 to 2021.
#'
#' @docType data
#' @name Transistors
#' @usage data(Transistors)
#' @details
#'   A data frame with 39 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Transistors}}
#'   }
#'
#' @source
#' Number of transistors in an integrated circuit from ``Moore's Law: The number
#' of transistors per microprocessor.'' Accessed on May 8, 2024.
#'
#' @references
#' https://ourworldindata.org/grapher/transistors-per-microprocessor.
#'
#' @examples
#' data(Transistors)
#'
NA

#' @title Average Worldwide CO2 Levels
#'
#' @description A data set containing the average worldwide carbon dioxide concentration
#' level in parts per million from 1993 to 2023.
#'
#' @docType data
#' @name AverageCO2Levels
#' @usage data(AverageCO2Levels)
#' @details
#'   A data frame with 32 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Emissions}} (parts per million)
#'   }
#'
#' @source
#' Average carbon dioxide levels in the atmosphere worldwide from 1959 to 2023
#' (in parts per million). Accessed on October 1, 2024.
#'
#' @references
#' https://www.statista.com/statistics/1091926/atmospheric-concentration-of-co2-historic/
#'
#' @examples
#' data(AverageCO2Levels)
#'
NA

#' @title Dow Jones Industrial Average Closing Value
#'
#' @description A data set containing the closing stock market value of the Dow Jones
#' Industrial Average on the last day of each quarter from June 30, 1896
#' (quarter 1) through September 30, 2024 (quarter 515).
#'
#' @docType data
#' @name DJIA
#' @usage data(DJIA)
#' @details
#'   A data frame with 515 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}}
#'     \item{\code{Close}}
#'   }
#'
#' @source
#' Closing stock market value of the Dow Jones Industrial Average at the end of
#' each quarter from June 30, 1896 through September 30, 2024 from
#' ``^DJI --- Nasdaq Composite --- U.S. --- Stooq.'' Accessed on October 1, 2024.
#'
#' @references
#' http://stooq.com/q/d/?s=^dji&i=q.
#'
#' @examples
#' data(DJIA)
#'
NA

#' @title Solar photovoltaic capacity in United States
#'
#' @description A data set containing the cumulative solar photovoltaic capacity in the
#' United States from 2000 to 2023 measured in megawatts.
#'
#' @docType data
#' @name SolarCapacity
#' @usage data(SolarCapacity)
#' @details
#'   A data frame with 24 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Capacity}} (in megawatts)
#'   }
#'
#' @source
#' Cumulative solar PV capacity in the United States from 2000 to 2023
#' (in megawatts). Accessed on October 2, 2024.
#'
#' @references
#' https://www.statista.com/statistics/232863/cumulative-solar-pv-capacity/
#'
#' @examples
#' data(SolarCapcity)
#'
NA

#' @title Smartphone Users Worldwide
#'
#' @description A data set containing the worldwide number of smartphone users from 2014-2024
#' in millions.
#'
#' @docType data
#' @name SmartphoneUsers
#' @usage data(SmartphoneUsers)
#' @details
#'   A data frame with 11 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of smartphone users worldwide from 2014 to 2029 (in millions).
#' Accessed on October 2, 2024.
#'
#' @references
#' https://www.statista.com/forecasts/1143723/smartphone-users-in-the-world
#'
#' @examples
#' data(SmartphoneUsers)
#'
NA

#' @title Active Paypal Accounts
#'
#' @description A data set containing the global number of active Paypal accounts in millions
#' each quarter from the first quarter in 2010 (Quarter=1).
#'
#' @docType data
#' @name PaypalAccounts
#' @usage data(PaypalAccounts)
#' @details
#'   A data frame with 48 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}}
#'     \item{\code{Accounts}} (in millions)
#'   }
#'
#' @source
#' Global user number of PayPal from 1st quarter 2010 to 2nd quarter 2024. Accessed
#' on October 2, 2024.
#'
#' @references
#' https://www.statista.com/statistics/218493/paypals-total-active-registered-accounts-from-2010/
#'
#' @examples
#' data(PaypalAccounts)
#'
NA

#' @title Cellular Subscriptions Worldwide
#'
#' @description A data set containing the worldwide number of mobile cellular subscriptions
#' per 100 people from 1980 to 2008.
#'
#' @docType data
#' @name CellularSubscriptions
#' @usage data(CellularSubscriptions)
#' @details
#'   A data frame with 29 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Subscriptions}} (per 100 people)
#'   }
#'
#' @source
#' Mobile cellular subscriptions (per 100 people). Accessed on October 2, 2024.
#'
#' @references
#' https://data.worldbank.org/indicator/IT.CEL.SETS.P2?end=2023&start=1960&view=chart
#'
#' @examples
#' data(CellularSubscriptions)
#'
NA

#' @title Biomass of OneSeed Juniper trees
#'
#' @description A data set containing the above ground biomass of Oneseed juniper trees in
#' kilograms as a function of the maximum height of the tree is meters.
#'
#' @docType data
#' @name JuniperTrees
#' @usage data(JuniperTrees)
#' @details
#'   A data frame with 18 observations on the following variables.
#'   \itemize{
#'     \item{\code{Height}} (in meters)
#'     \item{\code{BioMass}} (in kilograms)
#'   }
#'
#' @source
#' Boschetti Fabio , Sauer Katherine J. , Litvak Marcy , Anderson Karen ,
#' Brazier Richard E., Allometric Relationships for Predicting Aboveground
#' Biomass and Sapwood Area of Oneseed Juniper (Juniperus monosperma) Trees,
#' Frontiers in Plant Science, Volume 11, 2020, doi:10.3389/fpls.2020.00094.
#' Accessed on October 9, 2024.
#'
#' @references
#' https://www.frontiersin.org/journals/plant-science/articles/10.3389/fpls.2020.00094
#'
#' @examples
#' data(JuniperTrees)
#'
NA

#' @title Body length of therapods
#'
#' @description A data set containing the body length in meters of different therapods as a
#' function of the skull length in meters.
#'
#' @docType data
#' @name TherapodLength
#' @usage data(TherapodLength)
#' @details
#'   A data frame with 19 observations on the following variables.
#'   \itemize{
#'     \item{\code{Skull}} (in meters)
#'     \item{\code{Body}} (in meters)
#'   }
#'
#' @source
#' Therrien, François & Henderson, Donald. (2007). My theropod is bigger than
#' yours...or not: Estimating body size from skull length in theropods. Journal
#' of Vertebrate Paleontology. 108-115. doi: 10.1671/0272-4634(2007)27[108:MTIBTY]
#' 2.0.CO;2. Accessed on October 8, 2024.
#'
#' @references
#' https://www.researchgate.net/publication/232687833_My_theropod_is_bigger_than_yoursor_not_Estimating_body_size_from_skull_length_in_theropods.
#'
#' @examples
#' data(TherapodLength)
#'
NA
#' @title Mammalian maximal metabolic rate
#'
#' @description A data set containing the maximal metabolic rate in mL/min of various
#' mammalian species as a function of their mass in kilograms
#'
#' @docType data
#' @name VO2Max
#' @usage data(VO2Max)
#' @details
#'   A data frame with 34 observations on the following variables.
#'   \itemize{
#'     \item{\code{Mass}} (in kilograms)
#'     \item{\code{VO2Max}} (in mL/min)
#'   }
#'
#' @source
#' Ewald R. Weibel, Leonardo D. Bacigalupe, Beat Schmitt, and Hans Hoppeler.
#' Allometric scaling of maximal metabolic rate in mammals: muscle aerobic
#' capacity as determinant factor, Respiratory Physiology & Neurobiology,
#' Volume 140, Issue 2, 2004, Pages 115-132, ISSN 1569-9048,
#' https://doi.org/10.1016/j.resp.2004.01.006. Accessed on October 8, 2024.
#'
#' @references
#' https://www.sciencedirect.com/science/article/pii/S1569904804000126.
#'
#' @examples
#' data(VO2Max)
#'
NA
#' @title Metabolic Rate of Mussels
#'
#' @description A data set containing the standard metabolic rate in mL/hr of mussels
#' as a function of their live weight in grams
#'
#' @docType data
#' @name MusselsMetabolic
#' @usage data(MusselsMetabolic)
#' @details
#'   A data frame with 47 observations on the following variables.
#'   \itemize{
#'     \item{\code{LW}} (in grams)
#'     \item{\code{SMR}} (in mL/hr)
#'   }
#'
#' @source
#' Ibarrola I, Arranz K, Markaide P, Navarro E (2022) Metabolic size scaling
#' reflects growth performance effects on age-size relationships in mussels
#' (Mytilus galloprovincialis). PLoS ONE 17(9): e0268053. Accessed on October 8, 2024.
#'
#' @references
#' https://doi.org/10.1371/journal.pone.0268053.
#'
#' @examples
#' data(MusselsMetabolic)
#'
NA
#' @title Engine Bore Diameter
#'
#' @description A data set containing the bore diameter (i.e. the diameter of
#' the cylinder) in millimeters as a function of the mass of various engines
#' in kilograms
#'
#' @docType data
#' @name EngineBore
#' @usage data(EngineBore)
#' @details
#'   A data frame with 39 observations on the following variables.
#'   \itemize{
#'     \item{\code{Mass}} (in kilograms)
#'     \item{\code{BoreLength}} (in millimeters
#'   }
#'
#' @source
#' Bore diameter as a function of engine mass from pages 60--61. McMahon,
#' Thomas A., and John Tyler Bonner. \emph{On Size and Life}. New York:
#' Scientific American Library, 1983.
#'
#' @examples
#' data(EngineBore)
#'
NA
#' @title Metablic Energy of Mammals
#'
#' @description A data set containing the total lifetime metabolic energy in
#' kilojoules for various mammals as a function of their body mass in kilograms
#'
#' @docType data
#' @name MammalEnergy
#' @usage data(MammalEnergy)
#' @details
#'   A data frame with 93 observations on the following variables.
#'   \itemize{
#'     \item{\code{Mass}} (in kilograms)
#'     \item{\code{Energy}} (kilojoules)
#'   }
#'
#' @source
#' Atanasov AT. The linear allometric relationship between total metabolic
#' energy per life span and body mass of mammals. Biosystems. 2007 Jul-Aug;
#' 90(1):224-33. doi: 10.1016/j.biosystems.2006.08.006. Epub 2006 Aug 23.
#' PMID: 17030408. Accessed on October 10, 2024.
#'
#' @references
#' https://www.sciencedirect.com/science/article/abs/pii/S0303264706001481?via\%3Dihub
#'
#' @examples
#' data(MammalEnergy)
#'
NA
#' @title Average Temperature in Lexington, KY
#'
#' @description A data set containing the average maximum temperature in Lexington,
#' Kentucky at the beginning of each month since October 2019.
#'
#' @docType data
#' @name TemperaturesLexington
#' @usage data(TemperaturesLexington)
#' @details
#'   A data frame with 61 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (since October 2019)
#'     \item{\code{Temperature}} (in degrees Fahrenheit)
#'   }
#'
#' @source
#' Average maximum temperature in Lexington Kentucky at the beginning of each month
#' since October 2019 from ``Lexington, KY Weather History. Accessed on January 7, 2025.
#'
#' @references
#' https://www.wunderground.com/history/monthly/us/ky/lexington/KLEX/date/2024-10.
#'
#' @examples
#' data(TemperaturesLexington)
#'
NA
#' @title Day Length in Duluth, MN
#'
#' @description A data set containing the day length in Duluth, MN measures in
#' hours on the first day of each month from October 2022 to October 2024.
#'
#' @docType data
#' @name DuluthDayLength
#' @usage data(DuluthDayLength)
#' @details
#'   A data frame with 25 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (since October 2022)
#'     \item{\code{Length}} (in hours)
#'   }
#'
#' @source
#' Duluth, Minnesota, USA -- Sunrise, Sunset, and Daylength, October 2024.
#' Accessed on October 24, 2024.
#'
#' @references
#' https://www.timeanddate.com/sun/usa/duluth
#'
#' @examples
#' data(DuluthDayLength)
#'
NA
#' @title United States Electricity Demand
#'
#' @description A data set containing the United States electricity demand in
#' megawatt hours from October 1, 2024 to October 5, 2024 as a function of time
#' in hours.
#'
#' @docType data
#' @name ElectricityDemand
#' @usage data(ElectricityDemand)
#' @details
#'   A data frame with 120 observations on the following variables.
#'   \itemize{
#'     \item{\code{Time}} (hours since October 1, 2024)
#'     \item{\code{Length}} (in megawatt hours)
#'   }
#'
#' @source
#' U.S. electricity overview (demand, forecast demand, net generation, and total
#' interchange) 10/1/2024 - 10/5/24, Eastern Time. Accessed on October 24, 2024.
#'
#' @references
#' https://www.eia.gov/electricity/gridmonitor/dashboard/custom/pending
#'
#' @examples
#' data(ElectricityDemand)
#'
NA

#' @title KeyWestTides
#'
#' @description A data set containing the tidal depth relative to the mean lower
#' low water (MLLW) level in feet as a function of time in minutes in Key West,
#' Florida.
#'
#' @docType data
#' @name KeyWestTides
#' @usage data(KeyWestTides)
#' @details
#'   A data frame with 960 observations on the following variables.
#'   \itemize{
#'     \item{\code{Time}} (in minutes)
#'     \item{\code{Depth}} (in feet)
#'   }
#'
#' @source
#' NOAA/NOS/CO-OPS Observed Water Levels at 8724580, Key West, FL from
#' 2024/09/09 00:00 GMT to 2024/09/12 23:59 GMT. Accessed on October 23, 2024
#'
#' @references
#' https://tidesandcurrents.noaa.gov/waterlevels.html?id=8724580
#'
#' @examples
#' data(KeyWestTides)
#'
NA

#' @title Worldwide Mobile Cellular Subscriptions
#'
#' @description A data set containing the worldwide number of mobile cellular
#' subscriptions per 100 people from 1980 to 2023.
#'
#' @docType data
#' @name CellularSubscriptions2
#' @usage data(CellularSubscriptions2)
#' @details
#'   A data frame with 44 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Subscriptions}} (per 100 people)
#'   }
#'
#' @source
#' Mobile cellular subscriptions (per 100 people). Accessed on October 2, 2024.
#'
#' @references
#' https://data.worldbank.org/indicator/IT.CEL.SETS.P2
#'
#' @examples
#' data(CellularSubscriptions2)
#'
NA
#' @title United States Population
#'
#' @description A data set containing the population of the United States in
#' thousands of people each decade.
#'
#' @docType data
#' @name USPopulationDecade
#' @usage data(USPopulationDecade)
#' @details
#'   A data frame with 23 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Population}} (in thousands of people)
#'   }
#'
#' @source
#' Population of the United States from 1610 to 2020 (in thousands). Accessed
#' on July 22, 2025.
#'
#' @references
#' https://www.statista.com/statistics/1067138/population-united-states-historical/
#'
#' @examples
#' data(USPopulationDecade)
#'
NA
#' @title Height of a Sunflower
#'
#' @description A data set containing the height of a sunflower in centimeters
#' as a function of the day.
#'
#' @docType data
#' @name SunflowerHeight
#' @usage data(SunflowerHeight)
#' @details
#'   A data frame with 13 observations on the following variables.
#'   \itemize{
#'     \item{\code{Day}}
#'     \item{\code{Height}} (in centimeters)
#'   }
#'
#' @source
#' Reed, H.S. and Holland, R. H., The Growth of an Annual Plant Helianthus,
#' \emph{Proceedings of the National Academy of Sciences} (USA), 5, 135-144 (1919).
#'
#' @examples
#' data(SunflowerHeight)
#'
NA
#' @title Active X Users Worldwide
#'
#' @description A data set containing the number of active X (formerly Twitter)
#' users worldwide in millions each quarter from the first quarter of 2020 to
#' the first quarter of 2019.
#'
#' @docType data
#' @name XUsers
#' @usage data(XUsers)
#' @details
#'   A data frame with 37 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Users}} (in millions)
#'   }
#'
#' @source
#' Number of monthly active X (formerly Twitter) users worldwide from 1st
#' quarter 2010 to 1st quarter 2019. Accessed on January 15, 2025.
#'
#' @references
#' http://www.statista.com/statistics/282087/number-of-monthly-active-twitter-users/
#'
#' @examples
#' data(XUsers)
#'
NA
#' @title Mean Hen Weight
#'
#' @description A data set containing the mean hen weight of hens (female
#' chickens) in grams as a function of the age in days.
#'
#' @docType data
#' @name HenWeight
#' @usage data(HenWeight)
#' @details
#'   A data frame with 28 observations on the following variables.
#'   \itemize{
#'     \item{\code{Day}}
#'     \item{\code{Weight}} (in grams)
#'   }
#'
#' @source
#' Aggrey, S.E. Comparison of Three Nonlinear and Spline Regression Models for
#' Describing Chicken Growth Curves. \emph{Poultry Science}, Volume 81, Issue 12,
#' December 1, 2022, 1782-1788.
#'
#' @examples
#' data(HenWeight)
#'
NA
#' @title United States Nuclear Tests
#'
#' @description A data set containing the cumulative number of nuclear tests
#' conducted by the United States as a function of the year.
#'
#' @docType data
#' @name USNuclearTests
#' @usage data(USNuclearTests)
#' @details
#'   A data frame with 48 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Tests}}
#'   }
#'
#' @source
#' United States Nuclear Tests July 1945 through September 1992. U.S. Department
#' of Energy Nevada Operations Office. DOE/NV—209REV15, December 2000. Accessed
#' on June 17, 2025.
#'
#' @references
#' https://www.osti.gov/opennet/manhattan-project-history/publications/DOENuclearTests.pdf
#'
#' @examples
#' data(USNuclearTests)
#'
NA
#' @title Sunrise in Cancun, Mexico
#'
#' @description A data set containing the time of sunrise in Cancun, Mexico in
#' minutes after 6 AM on the first day of each month from July 2023 to August 2025.
#'
#' @docType data
#' @name SunriseCancun
#' @usage data(SunriseCancun)
#' @details
#'   A data frame with 26 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (since July 2023)
#'     \item{\code{Sunrise}} (minutes after 6 AM)
#'   }
#'
#' @source
#' Cancun, Quintana Roo, Mexico — Sunrise, Sunset, and Daylength, August 2025.
#' Accessed on August 4, 2025.
#'
#' @references
#' https://www.timeanddate.com/sun/mexico/cancun
#'
#' @examples
#' data(SunriseCancun)
#'
NA
#' @title Length of Avian Femurs
#'
#' @description A data set containing the length of avian femurs in millimeters as
#' a function of the body mass of the avian species in kilograms.
#'
#' @docType data
#' @name AvianFemur
#' @usage data(AvianFemur)
#' @details
#'   A data frame with 22 observations on the following variables.
#'   \itemize{
#'     \item{\code{Mass}} (in kilograms)
#'     \item{\code{Length}} (in millimeters)
#'   }
#'
#' @source
#' Prange, H.D., Anderson, J.F., and Rahn, H. Scaling of Skeletal Mass to Body
#' Mass in Birds and Mammals. \emph{The American Naturalist}, Vol. 113, No. 1
#' (Jan. 1979), pp. 103-122. Accessed on Augut 1, 2025.
#'
#' @references
#' https://www.jstor.org/stable/2459945
#'
#' @examples
#' data(AvianFemur)
#'
NA
#' @title Worldwide Electric Vehicle Market Share
#'
#' @description A data set containing the worldwide market share of electric
#' vehicles as a percentage of passenger vehicle sales from 2015 to 2023.
#'
#' @docType data
#' @name EVMarketShare
#' @usage data(EVMarketShare)
#' @details
#'   A data frame with 9 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Share}}
#'   }
#'
#' @source
#' Global market share of electric vehicles within passenger vehicle sales
#' between 2015 and 2023, with a forecast through 2030. Accessed on June 18, 2025.
#'
#' @references
#' https://www.statista.com/statistics/1371599/global-ev-market-share/
#'
#' @examples
#' data(EVMarketShare)
#'
NA
#' @title Revenue of Tesla
#'
#' @description A data set containing the revenue of Tesla from 2008 to 2024 in
#' millions of US dollars.
#'
#' @docType data
#' @name TeslaRevenue
#' @usage data(TeslaRevenue)
#' @details
#'   A data frame with 9 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Revenue}}  (in millions of US dollars)
#'   }
#'
#' @source
#' Revenue of Tesla from 2008 to 2024 (in millions U.S. dollars).
#' Accessed on June 18, 2025.
#'
#' @references
#' https://www.statista.com/statistics/272120/revenue-of-tesla/
#'
#' @examples
#' data(TeslaRevenue)
#'
NA
#' @title Mean Rooster Weight
#'
#' @description A data set containing the mean weight of roosters in grams as a
#' function of the age in days.
#'
#' @docType data
#' @name RoosterWeight
#' @usage data(RoosterWeight)
#' @details
#'   A data frame with 28 observations on the following variables.
#'   \itemize{
#'     \item{\code{Day}}
#'     \item{\code{Weight}}  (in grams)
#'   }
#'
#' @source
#' Aggrey, S.E. Comparison of Three Nonlinear and Spline Regression Models for
#' Describing Chicken Growth Curves. \emph{Poultry Science}, Volume 81, Issue 12,
#' December 1, 2022, 1782-1788.
#'
#' @examples
#' data(RoosterWeight)
#'
NA
#' @title Revenue of Nike
#'
#' @description A data set containing the revenue of Nike in millions of US
#' dollars from 2010 to 2023.
#'
#' @docType data
#' @name NikeRevenue
#' @usage data(NikeRevenue)
#' @details
#'   A data frame with 14 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Revenue}}  (in millions of US dollars)
#'   }
#'
#' @source
#' Revenue of Nike from 2005 to 2024 (in million U.S. dollars). Accessed on
#' June 18, 2025.
#'
#' @references
#' https://www.statista.com/statistics/241683/nikes-sales-worldwide-since-2004/
#'
#' @examples
#' data(NikeRevenue)
#'
NA
#' @title Daylength in Fairbanks, Alaska
#'
#' @description A data set containing the daylength in Fairbanks, Alaska in hours
#' from August 2020 to August 2025.
#'
#' @docType data
#' @name DaylengthFairbanks
#' @usage data(DaylengthFairbanks)
#' @details
#'   A data frame with 61 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (since August 2020)
#'     \item{\code{Daylength}}  (in hours)
#'   }
#'
#' @source
#' Fairbanks, Alaska, USA — Sunrise, Sunset, and Daylength, August 2025.
#' Accessed on August 4, 2025.
#'
#' @references
#' https://www.timeanddate.com/sun/usa/fairbanks
#'
#' @examples
#' data(DaylengthFairbanks)
#'
NA
#' @title US Electricity Generation
#'
#' @description A data set containing the United States net electricity generation
#' in terawatt-hours from 1950 to 2024.
#'
#' @docType data
#' @name USPowerProduction
#' @usage data(USPowerProduction)
#' @details
#'   A data frame with 27 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Power}}  (in terawatt-hours)
#'   }
#'
#' @source
#' Net electricity generation in the United States from 1950 to 2024
#' (in terawatt-hours). Accessed on June 18, 2025.
#'
#' @references
#' https://www.statista.com/statistics/188521/total-us-electricity-net-generation/
#'
#' @examples
#' data(USPowerProduction)
#'
NA
#'
#' @title Number of Verizon Employees
#'
#' @description A data set containing the number of employees at Verizon in
#' thousands from 2007 to 2024.
#'
#' @docType data
#' @name VerizonEmployees
#' @usage data(VerizonEmployees)
#' @details
#'   A data frame with 18 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Employees}}  (in thousands)
#'   }
#'
#' @source
#' Number of employees at Verizon from 2007 to 2024. Accessed on August 1, 2025.
#'
#' @references
#' https://www.statista.com/statistics/257304/number-of-employees-at-verizon/
#'
#' @examples
#' data(VerizonEmployees)
#'
NA
#' @title United States Tax Receipts
#'
#' @description A data set containing the total amount of United States federal
#' government receipts in billions of US dollars each quarter from January 1947
#' to January 2025.
#'
#' @docType data
#' @name USTaxReceipts
#' @usage data(USTaxReceipts)
#' @details
#'   A data frame with 313 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since January 1947)
#'     \item{\code{Receipts}}  (in billions of US dollars)
#'   }
#'
#' @source
#' Federal government current tax receipts, billions of US dollars, seasonally
#' adjusted annual rate. Accessed on August 1, 2025
#'
#' @references
#'https://fred.stlouisfed.org/series/W006RC1Q027SBEA
#'
#' @examples
#' data(USTaxReceipts)
#'
NA
#' @title Palm Length of Fiddler Crabs
#'
#' @description A data set containing the palm length (chela size) of growing
#' male fiddler crabs as a function of the body size (carapace breadth), both
#' measured in millimeters.
#'
#' @docType data
#' @name FiddlerCrabs
#' @usage data(FiddlerCrabs)
#' @details
#'   A data frame with 19 observations on the following variables.
#'   \itemize{
#'     \item{\code{BodySize}} (in millimeters)
#'     \item{\code{PalmLength}}  (in millimeters)
#'   }
#'
#' @source
#' Miller, D.C. Growth in Uca, 1. Ontogeny of Asymmetry in Uca pugilator (Bosc)
#' (Decapoda, Ocypodidae). \emph{Crustaceana}, Vol. 24, No. 1 (Jan., 1973), pp.
#' 119-131. Accessed on August 1, 2025.
#'
#' @references
#' https://www.jstor.org/stable/20101959
#'
#' @examples
#' data(FiddlerCrabs)
#'
NA
#' @title Worldwide Flights Performed
#'
#' @description A data set containing the worldwide number of flights performed
#' by the global airline industry in millions from 2004 to 2019.
#'
#' @docType data
#' @name FlightsWorldwide
#' @usage data(FlightsWorldwide)
#' @details
#'   A data frame with 16 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Flights}}  (in millions)
#'   }
#'
#' @source
#' Number of flights performed by the global airline industry from 2004 to 2024,
#' with a forecast for 2025 (in millions). Accessed on August 2, 2025.
#'
#' @references
#' https://www.statista.com/statistics/564769/airline-industry-number-of-flights/
#'
#' @examples
#' data(FlightsWorldwide)
#'
NA
#' @title Tides in St. Johns, Newfoundland
#'
#' @description A data set containing the water levels in meters at St. Johns,
#' Newfoundland on the Bay of Fundy each hour from midnight July 13, 2025 to
#' midnight July 15, 2025.
#'
#' @docType data
#' @name StJohnsTides
#' @usage data(StJohnsTides)
#' @details
#'   A data frame with 672 observations on the following variables.
#'   \itemize{
#'     \item{\code{Hour}} (since midnight July 23, 2025)
#'     \item{\code{Level}}  (in meters)
#'   }
#'
#' @source
#' Water levels at St. Johns relative to chart datum. St. Johns - 00905.
#' Accessed on August 2, 2025.
#'
#' @references
#' https://tides.gc.ca/en/stations/00905/2025-07-13
#'
#' @examples
#' data(StJohnsTides)
#'
NA
#' @title Weight of Threadfin Bream
#'
#' @description A data set containing the weight of threadfin bream measured in
#' grams as a function of their length in centimeters
#'
#' @docType data
#' @name ThreadfinBream
#' @usage data(ThreadfinBream)
#' @details
#'   A data frame with 16 observations on the following variables.
#'   \itemize{
#'     \item{\code{Length}} (in centimeters)
#'     \item{\code{Weight}}  (in grams)
#'   }
#'
#' @source
#' Pauly, D., Some simple methods for the 1983 assessment of tropical fish
#' stocks.\emph{FAO Fish.Tech.Pap}., (234):52 p.
#'
#' @examples
#' data(ThreadfinBream)
#'
NA
#' @title Worldwide Number of Paypal Accounts
#'
#' @description A data set containing the worldwide number of Paypal accounts in
#' millions from the first quarter of 2010 (Quarter=1) to the first quarter of 2025.
#'
#' @docType data
#' @name PaypalUsers
#' @usage data(PaypalUsers)
#' @details
#'   A data frame with 61 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since first Quarter of 2010)
#'     \item{\code{Accounts}}  (in millions)
#'   }
#'
#' @source
#' Global user number of Paypal from 1st quarter 2010 to 1st quarter 2025.
#' Accessed on June 18, 2025.
#'
#' @references
#' https://www.statista.com/statistics/218493/paypals-total-active-registered-accounts-from-2010/
#'
#' @examples
#' data(PaypalUsers)
#'
NA
#' @title United States National Debt
#'
#' @description A data set containing the total United States pulic debt in millions
#' of US dollars each quarter from the first quarter of 1966 to the first quarter
#' of 2025.
#'
#' @docType data
#' @name USNationalDebt
#' @usage data(USNationalDebt)
#' @details
#'   A data frame with 237 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since first Quarter of 1966)
#'     \item{\code{Debt}}  (in millions of US dollars)
#'   }
#'
#' @source
#' U.S. Department of the Treasury. Fiscal Service, Federal Debt: Total Public
#' Debt [GFDEBTN], retrieved from FRED, Federal Reserve Bank of St. Louis.
#' Accessed on August 15, 2025.
#'
#' @references
#' https://fred.stlouisfed.org/series/GFDEBTN
#'
#' @examples
#' data(USNationalDebt)
#'
NA
#' @title United States Gross Domestic Product
#'
#' @description A data set containing the gross domestic product of the United States
#' in billions of US dollars each quarter from the first quarter of 1966 to the
#' second quarter of 2025.
#'
#' @docType data
#' @name USGrossDomesticProduct
#' @usage data(USGrossDomesticProduct)
#' @details
#'   A data frame with 238 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since first Quarter of 1966)
#'     \item{\code{GDP}}  (in billions of US dollars)
#'   }
#'
#' @source
#' U.S. Bureau of Economic Analysis, Gross Domestic Product [GDP], retrieved
#' from FRED, Federal Reserve Bank of St. Louis. Accessed on August 15, 2025.
#'
#' @references
#' https://fred.stlouisfed.org/series/GDP
#'
#' @examples
#' data(USGrossDomesticProduct)
#'
NA
#' @title United States Debt as a Percentage of GDP
#'
#' @description A data set containing the total public debt of the United
#' States as a percentage of the US gross domestic product from the first
#' quarter of 1966 to the first quarter of 2025.
#'
#' @docType data
#' @name USGDPDebt
#' @usage data(USGDPDebt)
#' @details
#'   A data frame with 237 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (since first Quarter of 1966)
#'     \item{\code{Percent}}
#'   }
#'
#' @source
#' U.S. Office of Management and Budget and Federal Reserve Bank of St. Louis,
#' Federal Debt: Total Public Debt as Percent of Gross Domestic Product
#' [GFDEGDQ188S], retrieved from FRED, Federal Reserve Bank of St. Louis.
#' Accessed on August 10, 2025.
#'
#' @references
#' https://fred.stlouisfed.org/series/GFDEGDQ188S
#'
#' @examples
#' data(USGDPDebt)
#'
NA
#' @title Sales Volume of Wine in United States
#'
#' @description A data set containing the sales volume of wine in the United
#' States, measured in millions of 9-liter cases, from 1999 to 2023.
#'
#' @docType data
#' @name WineSales
#' @usage data(WineSales)
#' @details
#'   A data frame with 23 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Cases}} (millions of 9-liter cases)
#'   }
#'
#' @source
#' Sales volume of wine in the United States from 1999 to 2023 (in million
#' 9-liter cases). Accessed on March 11, 2025.
#'
#' @references
#' https://www.statista.com/statistics/715474/wine-sales-in-us/
#'
#' @examples
#' data(WineSales)
#'
NA
#' @title Wine Quality of Red Vinho Verde Wines from Portugal
#'
#' @description A data set containing data on 1599 red vinho verde wines from
#' Portugal. For each wine, the alcohol level, the volatile acidity of the wine,
#' amount of sulphates present in the wine, and a sensory score assigned by a
#' human expert based on the wines smell is recorded.
#'
#' @docType data
#' @name WineQuality
#' @usage data(WineQuality)
#' @details
#'   A data frame with 1599 observations on the following variables.
#'   \itemize{
#'     \item{\code{volatileAcidity}} (in grams per liter)
#'     \item{\code{sulphates}} (parts per million)
#'     \item{\code{alcohol}} (percent)
#'     \item{\code{quality}} (number between 0 and 10)
#'   }
#'
#' @source
#' Cortez, P., Cerdeira, A., Almeida, F., Matos, T., & Reis, J. (2009). Wine
#' Quality [Dataset]. UCI Machine Learning Repository. Accessed on May 21, 2025.
#'
#' @references
#' https://doi.org/10.24432/C56S3T.
#'
#' @examples
#' data(WineQuality)
#'
NA
#' @title Height of Children
#'
#' @description A data set containing data on the height of 465 male children and the
#' height of both their mother and father.
#'
#' @docType data
#' @name GaltonMale
#' @usage data(GaltonMale)
#' @details
#'   A data frame with 465 observations on the following variables.
#'   \itemize{
#'     \item{\code{father}} (height of father in inches)
#'     \item{\code{mother}} (height of mother in inches)
#'     \item{\code{height}} (height of child in inches)
#'   }
#'
#' @source
#' Hanley, J.A. (2004). ``Transmuting" women into men: Galton's family data on
#' human stature. The American Statistician, vol. 58, no. 3, pp. 237-243.
#' Accessed on May 21, 2025.
#'
#' @references
#' https://www.medicine.mcgill.ca/epidemiology/hanley/galton/
#'
#' @examples
#' data(GaltonMale)
#'
NA
#' @title California Housing Data from 1990 US Census
#'
#' @description A data set containing data on housing prices in California from
#' the 1990 Census. Each data point is from one census block and contains data
#' on the median age, total number of rooms, total number of bedrooms, population,
#' number of households, median income, and median value of the houses within
#' that census block.
#'
#' @docType data
#' @name CaliforniaHousing
#' @usage data(CaliforniaHousing)
#' @details
#'   A data frame with 20433 observations on the following variables.
#'   \itemize{
#'     \item{\code{Age}} (median age of house within block)
#'     \item{\code{Rooms}} (total number of rooms within block)
#'     \item{\code{Bedrooms}} (total number of bedrooms within block)
#'     \item{\code{Population}} (total number of people residing within block)
#'     \item{\code{Households}} (total number of households residing within block)
#'     \item{\code{MedianIncome}} (median income within block)
#'     \item{\code{MedianValue}} (median home value within block)
#'   }
#'
#' @source
#' Data on California housing from the 1990 census. Accessed on August 3, 2025.
#'
#' @references
#' https://www.dcc.fc.up.pt/~ltorgo/Regression/cal_housing.html
#'
#' @examples
#' data(CaliforniaHousing)
#'
NA
#' @title Fuel Efficiency of Automobiles
#'
#' @description A data set containing data on predicting the MPG of 392
#' automobiles based on the number of cylinders, engine displacement, engine
#' horsepower, vehicle weight, acceleration, and year.
#'
#' @docType data
#' @name AutoMPG
#' @usage data(AutoMPG)
#' @details
#'   A data frame with 392 observations on the following variables.
#'   \itemize{
#'     \item{\code{MPG}}
#'     \item{\code{Cylinders}} (number of cylinders in engine)
#'     \item{\code{Displacement}} (in cubic inches)
#'     \item{\code{Horsepower}}
#'     \item{\code{Weight}} (in pounds)
#'     \item{\code{Acceleration}} (in meters per second squared)
#'     \item{\code{Year}} (year of production; e.g. 70 is the year 1970)
#'   }
#'
#' @source
#' Data on predicting the MPG of 392 automobiles based on the number of
#' cylinders, engine displacement, engine horsepower, vehicle weight, acceleration,
#' and year. Accessed on August 3, 2025.
#'
#' @references
#' https://archive.ics.uci.edu/dataset/9/auto+mpg
#'
#' @examples
#' data(AutoMPG)
#'
NA
#' @title Weight of Bream
#'
#' @description Weight of 56 bream fish in grams as a function of their vertical
#' length (in cm), diagonal length (in cm), cross length (in cm), height (in cm),
#' and diagonal width (in cm).
#'
#' @docType data
#' @name FishWeights
#' @usage data(FishWeights)
#' @details
#'   A data frame with 56 observations on the following variables.
#'   \itemize{
#'     \item{\code{Weight}} (in grams)
#'     \item{\code{Vertial}} (vertical length in centimeters)
#'     \item{\code{Diagonal}} (diagonal length in centimeters)
#'     \item{\code{Cross}} (cross length in centimeters)
#'     \item{\code{Height}} (in centimeters)
#'     \item{\code{Width}} (diagonal width in centimeters)
#'   }
#'
#' @source
#' FishMarket: Estimate the weight of fish based on its species and the physical
#' measurements. Accessed on August 3, 2025
#'
#' @references
#' https://www.kaggle.com/datasets/vipullrathod/fish-market
#'
#' @examples
#' data(FishWeights)
#'
NA
#' @title Nintendo Switch Sales
#'
#' @description A data set containing the cumulative sales of the Nintendo Switch worldwide from 2017 to
#' 2024.
#'
#' @docType data
#' @name NintendoSwitch
#' @usage data(NintendoSwitch)
#' @details
#'   A data frame with 8 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Sales}} (in millions of units)
#'   }
#'
#' @source
#' Annual unit sales of the Nintendo Switch worldwide from 2017 to 2024.
#' Accessed on August 3, 2025.
#'
#' @references
#' https://www.statista.com/statistics/1085606/annual-unit-sales-nintendo-switch-worldwide/
#'
#' @examples
#' data(NintendoSwitch)
#'
NA
#' @title Online Advertising Revenue
#'
#' @description A data set containing the online advertising revenue in the
#' United States from 2000 to 2024 in billion of U.S. dollars.
#'
#' @docType data
#' @name OnlineAdvertising
#' @usage data(OnlineAdvertising)
#' @details
#'   A data frame with 25 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Revenue}} (in billions of US dollars)
#'   }
#'
#' @source
#' Online advertising revenue in the United States from 2000 to 2024 (in billion
#' U.S. dollars). Accessed on August 3, 2025.
#'
#' @references
#' https://www.statista.com/statistics/183816/us-online-advertising-revenue-since-2000/
#'
#' @examples
#' data(OnlineAdvertising)
#'
NA
#' @title Student Loan Debt in United States
#'
#' @description A data set containing the value of outstanding student loans in
#' the United States in billions of US dollars each quarter from the first quarter
#' of 2006 (Quarter=1) to the fourth quarter of 2024.
#'
#' @docType data
#' @name StudentLoans
#' @usage data(StudentLoans)
#' @details
#'   A data frame with 76 observations on the following variables.
#'   \itemize{
#'     \item{\code{Quarter}} (quarter since first quarter of 2006)
#'     \item{\code{Loans}} (in billions of US dollars)
#'   }
#'
#' @source
#' Value of outstanding student loans in the United States from Q1 2006 to Q4
#' 2024 (in billion U.S. dollars). Accessed on August 3, 2025.
#'
#' @references
#' https://www.statista.com/statistics/1077038/value-outstanding-student-loans-us/
#'
#' @examples
#' data(StudentLoans)
#'
NA
#' @title United States Inflation Rate
#'
#' @description A data set containing the annual inflation rate of the United
#' States from 2010 to 2023.
#'
#' @docType data
#' @name USInflationRate
#' @usage data(USInflationRate)
#' @details
#'   A data frame with 14 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Rate}}
#'   }
#'
#' @source
#' Projected annual inflation rate in the United States from 2010 to 2029.
#' Accessed on May 31, 2025.
#'
#' @references
#' https://www.statista.com/statistics/244983/projected-inflation-rate-in-the-united-states/
#'
#' @examples
#' data(USInflationRate)
#'
NA
#' @title New York City Housing Prices
#'
#' @description A data set containing the contains the median sales price of
#' housing in New York City from October 2022 (Month=0) to October 2024 (Month=24).
#'
#' @docType data
#' @name NYCHousingPrices
#' @usage data(NYCHousingPrices)
#' @details
#'   A data frame with 25 observations on the following variables.
#'   \itemize{
#'     \item{\code{Month}} (since October 2022)
#'     \item{\code{Price}} (in US dollars)
#'   }
#'
#' @source
#' Median sales price of housing in New York City from January 2019 to October
#' 2024 (in U.S. dollars). Accessed on May 31, 2025.
#'
#' @references
#' https://www.statista.com/statistics/1235655/median-sale-price-of-housing-new-york/
#'
#' @examples
#' data(NYCHousingPrices)
#'
NA
#' @title Profit of Addidas
#'
#' @description A data set containing the gross profit of Addidas in millions
#' of euros from 2006 to 2024.
#'
#' @docType data
#' @name AddidasProfit
#' @usage data(AddidasProfit)
#' @details
#'   A data frame with 19 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Profit}} (in millions of euros)
#'   }
#'
#' @source
#' Gross profit of Adidas from 2000 to 2024 (in million euros). Accessed on
#' May 31, 2025.
#'
#' @references
#' https://www.statista.com/statistics/268417/gross-profit-of-the-adidas-group-worldwide-since-2000/
#'
#' @examples
#' data(AddidasProfit)
#'
NA
#' @title United States Unemployment Rate
#'
#' @description A data set containing the annual United States unemployment rate
#' from 1990 to 2024.
#'
#' @docType data
#' @name UnemploymentRate
#' @usage data(UnemploymentRate)
#' @details
#'   A data frame with 35 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Rate}}
#'   }
#'
#' @source
#' Unemployment rate in the United States from 1990 to 2024. Accessed on
#' May 28, 2025.
#'
#' @references
#' https://www.statista.com/statistics/193290/unemployment-rate-in-the-usa-since-1990/
#'
#' @examples
#' data(UnemploymentRate)
#'
NA
#' @title United States Military Spending
#'
#' @description A data set containing the annual United States military spending
#' in billions of US dollars from 1960 to 2022.
#'
#' @docType data
#' @name USMilitarySpending
#' @usage data(USMilitarySpending)
#' @details
#'   A data frame with 35 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Spending}} (in billions of US dollars)
#'   }
#'
#' @source
#' U.S. Military Spending/Defense Budget 1960-2025. Accessed on May 28, 2025.
#'
#' @references
#' https://www.macrotrends.net/global-metrics/countries/usa/united-states/military-spending-defense-budget
#'
#' @examples
#' data(USMilitarySpending)
#'
NA
#' @title United States Cigarette Sales
#'
#' @description A data set containing the number of individual cigarettes sold
#' in the United States in billions each year from 1981 to 2022.
#'
#' @docType data
#' @name CigaretteSales
#' @usage data(CigaretteSales)
#' @details
#'   A data frame with 42 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Sales}} (in billions of individual cigarettes)
#'   }
#'
#' @source
#' Federal Trade Commission Cigarette Report for 2022. Accessed on June 5, 2025.
#'
#' @references
#' https://www.ftc.gov/system/files/ftc_gov/pdf/2022-Cigarette-Report.pdf
#'
#' @examples
#' data(CigaretteSales)
#'
NA
#' @title Temperature of Mediterranean Sea
#'
#' @description A data set containing the sea surface temperature of the
#' Mediterranean Sea in degrees Celsius from 1996 to 2023 relative to the
#' 1991-2020 average.
#'
#' @docType data
#' @name MediterraneanSeaTemp
#' @usage data(MediterraneanSeaTemp)
#' @details
#'   A data frame with 28 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Temperature}} (in degrees Celsius relative to the 1991-2020 average)
#'   }
#'
#' @source
#' Sea surface temperature anomalies in the Mediterranean Sea from 1994 to 2023.
#' Accessed on June 13, 2025.
#'
#' @references
#' https://www.statista.com/statistics/1463322/sea-surface-temperature-anomalies-mediterranean-sea/
#'
#' @examples
#' data(MediterraneanSeaTemp)
#'
NA
#' @title Child Labor Law Violations
#'
#' @description A data set containing the number of minors employed in the United
#' States in violation of child labor laws from 1971 to 2024.
#'
#' @docType data
#' @name ChildLabor
#' @usage data(ChildLabor)
#' @details
#'   A data frame with 28 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Violations}}
#'   }
#'
#' @source
#' Child Labor. Accessed on June 24, 2025.
#'
#' @references
#' https://www.dol.gov/agencies/whd/data/charts/child-labor
#'
#' @examples
#' data(ChildLabor)
#'
NA
#' @title Online Retail Sales in the United Kingdom
#'
#' @description A data set containing the value of online retail sales in
#' billions of Great British pounds (GBP) in the United Kingdom from 2012 to 2022.
#'
#' @docType data
#' @name UKOnlineSales
#' @usage data(UKOnlineSales)
#' @details
#'   A data frame with 11 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}}
#'     \item{\code{Sales}} (in billions of GBP)
#'   }
#'
#' @source
#' Value of online retail sales in the United Kingdom (UK) from 2012 to 2022
#' (in billion GBP). Accessed on June 24, 2025.
#'
#' @references
#' https://www.statista.com/statistics/315506/online-retail-sales-in-the-united-kingdom/
#'
#' @examples
#' data(UKOnlineSales)
#'
NA
#' @title Car Sales
#'
#' @description A data set containing the price, year, and mileage of 23000 cars
#' for sale.
#'
#' @docType data
#' @name CarSales
#' @usage data(CarSales)
#' @details
#'   A data frame with 23000 observations on the following variables.
#'   \itemize{
#'     \item{\code{Year}} (year car was manufactured)
#'     \item{\code{Mileage}} (number of miles on car)
#'     \item{\code{Price}} (price of car in US dollars)
#'   }
#'
#' @source
#' Cars for Sale: Comprehensive Dataset of Cars for Sale with Detailed Features,
#' Pricing, accident. Accessed on July 18, 2025.
#'
#' @references
#' https://www.kaggle.com/datasets/benjnb/cars-for-sale
#'
#' @examples
#' data(CarSales)
#'
NA
#' @title Happiness in Southeastern Asian and Middle Eastern Countries
#'
#' @description A data set containing a happiness score (between 0 and 10) from
#' the 2023 World Happiness Report from 12 Southeastern Asian and Middle Eastern
#' countries along with the median income in United States dollars and the poverty
#' rate of the county.
#'
#' @docType data
#' @name Happiness
#' @usage data(Happiness)
#' @details
#'   A data frame with 12 observations on the following variables.
#'   \itemize{
#'     \item{\code{Happiness}} (score between 0 and 10)
#'     \item{\code{Income}} (median income in US dollars)
#'     \item{\code{Poverty}} (poverty rate)
#'   }
#'
#' @source
#' SA-ME Happiness Index: Education, Income & Life Satisfaction Metrics.
#' Accessed on July 18, 2025.
#'
#' @references
#' https://www.kaggle.com/datasets/towhid121/sa-me-happiness-index
#'
#' @examples
#' data(Happiness)
#'
NA
#' @title Sales Revenue based on Advertising Budget Breakdown
#'
#' @description A data set containing the sales revenue of various products in
#' millions of US dollars based on the TV, radio, and newspaper advertising
#' budget of the product in 1000's of US dollars.
#'
#' @docType data
#' @name Advertising
#' @usage data(Advertising)
#' @details
#'   A data frame with 200 observations on the following variables.
#'   \itemize{
#'     \item{\code{Sales}} (in millions of US dollars)
#'     \item{\code{TV}} (TV advertising budget in 1000's of US dollars)
#'     \item{\code{Radio}} (radio advertising budget in 1000's of US dollars)
#'     \item{\code{Newspaper}} (newspaper advertising budget in 1000's of US dollars)
#'   }
#'
#' @source
#' Advertising Sales Data Set: Advertising Budget & Sales Prediction using
#' Regression. Accessed on July 18, 2025.
#'
#' @references
#' https://www.kaggle.com/datasets/yasserh/advertising-sales-dataset
#'
#' @examples
#' data(Advertising)
#'
NA
#' @title Abalone Rings
#'
#' @description A data set containing the number of rings for 4177 abalone along
#' with their length, and live weight. The age of an abalone is the number of
#' rings + 1.5, but it is difficult to count the number of rings to determine
#' the age of an abalone.
#'
#' @docType data
#' @name Abalone
#' @usage data(Abalone)
#' @details
#'   A data frame with 1307 observations on the following variables.
#'   \itemize{
#'     \item{\code{Length}} (in millimeters)
#'     \item{\code{Weight}} (live weight in grams)
#'     \item{\code{Rings}} (number of rings)
#'   }
#'
#' @source
#' Abalone: Donated on 11/30/1995 to UC Irvine Machine Learning Repository.
#' Accessed on July 19, 2025.
#'
#' @references
#' https://archive.ics.uci.edu/dataset/1/abalone
#'
#' @examples
#' data(Abalone)
#'
NA
