% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{compareFeatures}
\alias{compareFeatures}
\title{Compare features' abundance obtained by prediction and measurement.}
\usage{
compareFeatures(
  predicted,
  measured,
  method = "spearman",
  adjmethod = "fdr",
  rsignif = 0.3,
  psignif = 0.05
)
}
\arguments{
\item{predicted}{A matrix or data frame. The feature table obtained by
prediction.}

\item{measured}{A matrix or data frame. The feature table obtained by
measurement. The abundances are expected to be normalized (i.e. proportion)
or be preprocessed by \code{\link[MMINP]{MMINP.preprocess}}.}

\item{method}{A character string indicating which correlation coefficient is
to be used for the \code{\link[stats]{cor.test}}. One of "pearson",
"kendall", or "spearman", can be abbreviated.}

\item{adjmethod}{A character string indicating correction
method (\code{\link[stats]{p.adjust}}). One of "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr", "none", can be abbreviated.}

\item{rsignif}{A numeric ranging from 0 to 1, the minimum correlation
coefficient of features which considered as well-predicted features.}

\item{psignif}{A numeric ranging from 0 to 1, the maximum adjusted p value of
features which considered as well-predicted features.}
}
\value{
A list containing a table of correlation results and a vector of
well-predicted features.
}
\description{
Compare features' abundance obtained by prediction and measurement.
}
