% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mofat.R
\name{mofat}
\alias{mofat}
\title{MOFAT}
\usage{
mofat(p, l, method = "best")
}
\arguments{
\item{p}{number of factors}

\item{l}{number of base runs}

\item{method}{choose among "uniform", "projection", and "best"}
}
\value{
\item{design}{MOFAT design}
}
\description{
This function can be used for generating MOFAT designs.
}
\details{
The \code{mofat} function generates the MOFAT design
for a given number of factors (\eqn{p\ge 2}) and
number of base runs (\eqn{l \ge 3}). The total number of runs in the MOFAT design will be \eqn{l(p+1)}.
A MOFAT design can be viewed as an optimized version of Morris screening design (Morris 1991) by exploiting
its connections with the Monte Carlo-based design of Sobol' (1993).
Please see Xiao et al. (2022) for details.

Three choices for the \code{method} are given: "uniform", "projection", and "best". Option "uniform" gives \code{l} equally-spaced levels
for the entire design, which are also balanced. "projection" option adjusts the levels of the two base matrices A and B such that
there are \eqn{2l} or \eqn{2l-1} levels in the design depending on \code{l} is even or odd. Option "best" (default) chooses the best
among the first two options using maximin distance criterion.
}
\examples{
#MOFAT with three base runs
mofat(p=10, l=3, method="uniform")
mofat(p=10, l=3, method="projection")

#MOFAT with five base runs
mofat(p=10,l=5)
dim(mofat(p=125,l=5))
}
\references{
Morris, M. D. (1991), “Factorial sampling plans for preliminary computational experiments,”
Technometrics, 33, 161–174.

Sobol’, I. M. (1993), “On sensitivity estimation for nonlinear mathematical models,” Mathematical
Modeling and Computational Experiments, 1, 407–414.

Xiao, Q., Joseph, V. R., and Ray, D. M. (2022). “Maximum One-Factor-At-A-Time  Designs for Screening in Computer Experiments”.
Technometrics, to appear.
}
\author{
Qian Xiao and V. Roshan Joseph
}
