% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Search.R
\name{Search}
\alias{Search}
\title{Searching for a multi-objective optimal completely randomised design.}
\usage{
Search(
  mood.object,
  algorithm = c("ptex", "coordex"),
  parallel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{mood.object}{Object of class \code{mood}, generated by \code{mood} function, containing the parameters of the experiment, the compound criterion and search parameters}

\item{algorithm}{Parameter specifying the search algorithm. If \code{ptex} (default for \eqn{K<=4}), the point-exchange algorithm is used, and if \code{coordex} (default for \eqn{K>4}), the coordinate-exchange.}

\item{parallel}{If \code{TRUE} use the \code{doFuture} package to run independent iterations of the algorithm in parallel using \code{foreach}. Requires \code{doFuture} library to be installed and a \code{Future} \code{plan} to be specified. See examples.}

\item{verbose}{If \code{TRUE}, progress messages through the search iterations are shown.}
}
\value{
Updated object of class \code{mood} containing the outputs generated by the search:
\itemize{
\item \code{X.design} Design matrix.
\item \code{df} The number of pure error degrees of freedom.
\item \code{X1} Primary model matrix for the found (nearly-) optimum design.
\item \code{X2} Model matrix of potential terms for the found (nearly-) optimum design.
\item \code{compound.value} The compound criterion value of the (nearly-) optimum design.
\item \code{criteria.values} Component criteria values of the (nearly-) optimum design.
\item \code{path} The "path" of compound criterion values of the optimum designs obtained after for each random start.
\item \code{time} Computation time.
\item \code{algorithm} Point exchange or coordinate exchange used to find the design?
\item \code{parallel} Were different runs of the algorithm performed across different CPU cores (\code{TRUE}/\code{FALSE})
}
}
\description{
Performing search for a (nearly) optimum factorial design, optimising with respect to a specified compound criterion.
}
\details{
\code{Search} takes the mood object as an input with all the parameters of the experiment. Runs a point-exchange or a coordinate-exchange algorithm, returns design and model matrices, computation time and criteria values.
See \insertCite{KoutraMOODE}{MOODE} for examples of using \code{parallel = TRUE}.
}
\examples{

example1 <- mood(K = 2, Levels = 3, Nruns = 10, criterion.choice = "GDP", 
                kappa = list(kappa.Ds = 1./3, kappa.DP = 1./3, kappa.LoF = 1./3), 
                control = list(tau2 = 0.1), 
                model_terms = list(primary.model = "first_order", 
                potential.terms = c("x12", "x22", "x1x2")))
# Using point exchange
Search_point <- Search(example1, algorithm = 'ptex')
Search_point
# Using coordinate exchange (the default for K>4)
Search_coord <- Search(example1)
Search_coord
}
\references{
\insertAllCited
}
\seealso{
\link{mood}
}
