% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{bh}
\alias{bh}
\title{bh represents one version of Beverton-Holt recruitment}
\usage{
bh(p, B)
}
\arguments{
\item{p}{a vector of the a and b parameters}

\item{B}{a vector, possibly of length 1, of spawning biomass levels}
}
\value{
a vector, the same length as B, of the predicted recruitment(s)
}
\description{
bh implements the Beverton-Holt stock recruitment
   equation R = a x B/(b + B), where R is the recruitment, a and
   b are the parameters and B is the spawning biomass. In this
   parameterization, a is the maximum recruitment level and b is the 
   biomass required to generate 0.5 x maximum recruitment. An common 
   alternative parameterization is to use R = S/(alpha + beta x S). Do not
   confuse a with alpha and b with beta!
}
\examples{
  B <- 1:3000
  rec <- bh(c(1000,200),B)
  plot1(B,rec,xlab="SpB",ylab="Recruitment",lwd=2)
}
