% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{facttonum}
\alias{facttonum}
\title{facttonum converts a vector of numeric factors into numbers}
\usage{
facttonum(invect)
}
\arguments{
\item{invect}{the vector of numeric factors to be converted back to numbers}
}
\value{
an output vector of numbers instead of the input factors
}
\description{
facttonum converts a vector of numeric factors into numbers.
    If the factors are not numeric then the outcome will be a series of NA.
    It is up to you to apply this function only to numeric factors. A warning
    will be thrown if the resulting output vector contains NAs
}
\examples{
 DepCat <- as.factor(rep(seq(100,600,100),2))
 print(DepCat)
 5 * DepCat[3]    # throws an error, cannot multiply a factor
 as.numeric(DepCat) # ordinal values of the factors
 as.numeric(levels(DepCat)) #converts the levels not the replicates
 DepCat <- facttonum(DepCat)
 DepCat / 2.0     # now all values back to values
 x <- factor(letters) 
 facttonum(x)     # this would be silly, characters are not numbers
}
