% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{outfit}
\alias{outfit}
\title{outfit tidy print of output from optim, nlminb, or nlm}
\usage{
outfit(inopt, backtran = TRUE, digits = 5, title = "", parnames = "")
}
\arguments{
\item{inopt}{the list object output by nlm, nlminb, or optim}

\item{backtran}{a logical default = TRUE If TRUE it assumes
that the parameters have been log-transformed for stability
and need back-transforming}

\item{digits}{the number of digits to round the backtransformed 
parameters. defaults to 5.}

\item{title}{character string used to label the output if desired,
default = empty character string}

\item{parnames}{default="" which means the estimated parameters
will merely be numbered. If a vector of names is given 
then this will be used instead, at least, for nlm and optim.}
}
\value{
nothing but it does print the list to the console tidily
}
\description{
outfit takes in the output list from either optim,
    nlminb, or nlm and prints it more tidily to the console, In the
    case of nlm it also prints the conclusion regarding the
    solution. It might be more effective to implement an S3 method.
}
\examples{
 x <- 1:10  # generate power function data from c(2,2) + random
 y <- c(2.07,8.2,19.28,40.4,37.8,64.68,100.2,129.11,151.77,218.94)
 alldat <- cbind(x=x,y=y)
 pow <- function(pars,x) return(pars[1] * x ^ pars[2])
 ssq <- function(pars,indat) {
    return(sum((indat[,"y"] - pow(pars,indat[,"x"]))^2))
 }  # fit a power curve using normal random errors
 pars <- c(2,2)
 best <- nlm(f=ssq,p=pars,typsize=magnitude(pars),indat=alldat)
 outfit(best,backtran=FALSE) #a=1.3134, b=2.2029 ssq=571.5804
}
